/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.message.queue.records;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.ISlot;
import org.jetbrains.annotations.NotNull;

public final class CRecordNotifyQueueRegistered
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject("5bdd97d8-60d7-46e2-9621-2f89d49ce2e9");
    public static final String NAME = "NotifyQueueRegistered";
    public static final String DESCRIPTION = "Notification that a queue has been added.";
    public static final String SLOT_QUEUE_ID = "QID";
    public static final String[] NAMESPACES = new String[0];
    public static final boolean IS_NANO_SERVICE = false;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static IId getQueueId(@NotNull CRecord aRecord, IId aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_QUEUE_ID);
        if (slot == null) {
            return aDefault;
        }
        return (IId)slot.getValue();
    }

    public static void setQueueId(@NotNull CRecord aRecord, IId aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.ID, aValue);
        aRecord.addSlot(SLOT_QUEUE_ID, slot);
    }
}

