/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.login.records;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.ISlot;
import org.jetbrains.annotations.NotNull;

public final class CRecordSessionValidate
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject("deb4b364-0890-4380-8c36-a142fcb29034");
    public static final String NAME = "SessionValidate";
    public static final String DESCRIPTION = "Validate a token.";
    public static final String SLOT_RIGHTS = "rights";
    public static final String SLOT_TOKEN = "token";
    public static final String SLOT_USER_ID = "userId";
    public static final String[] NAMESPACES = new String[0];
    public static final boolean IS_NANO_SERVICE = false;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static String[] getRights(@NotNull CRecord aRecord, String[] aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_RIGHTS);
        if (slot == null) {
            return aDefault;
        }
        return (String[])slot.getValue();
    }

    public static String getToken(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_TOKEN);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static String getUserId(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_USER_ID);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static void setRights(@NotNull CRecord aRecord, String[] aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.STRING_ARRAY, aValue);
        aRecord.addSlot(SLOT_RIGHTS, slot);
    }

    public static void setToken(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.STRING, aValue);
        aRecord.addSlot(SLOT_TOKEN, slot);
    }

    public static void setUserId(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.STRING, aValue);
        aRecord.addSlot(SLOT_USER_ID, slot);
    }
}

