/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.log;

import de.sillysky.nyssr.impl.log.CAbstractLogWriter;
import de.sillysky.nyssr.impl.service.CServiceRegistry;
import de.sillysky.nyssr.kernel.configuration.IKernelConfiguration;
import de.sillysky.nyssr.log.CLogDto;
import de.sillysky.nyssr.log.CUtilColoredWords;
import de.sillysky.nyssr.log.ELevel;
import de.sillysky.nyssr.log.ILogWriter;
import java.util.Arrays;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;

public class CDefaultConsoleLogWriter
extends CAbstractLogWriter
implements ILogWriter {
    private static final String[] GREEN_WORDS = new String[]{"successfully", "success", "okay", "ok"};
    private static final String[] RED_WORDS = new String[]{"failure", "failed", "error"};
    private static final String[] LIGHT_CYAN_WORDS = new String[]{"Try to", "start"};
    private static final String[] MAGENTA_WORDS = new String[]{"Warning"};
    private boolean mUseColors = true;

    @Override
    public void start() throws Exception {
        IKernelConfiguration kc = CServiceRegistry.getInstance().getService(IKernelConfiguration.class);
        if (kc != null) {
            this.mUseColors = kc.getPreferences("log").getBoolean("use_console_colors", false);
            Arrays.sort(GREEN_WORDS, Comparator.comparingInt(String::length).reversed());
            Arrays.sort(LIGHT_CYAN_WORDS, Comparator.comparingInt(String::length).reversed());
            Arrays.sort(RED_WORDS, Comparator.comparingInt(String::length).reversed());
            Arrays.sort(MAGENTA_WORDS, Comparator.comparingInt(String::length).reversed());
        }
    }

    @Override
    public void stop() throws Exception {
    }

    @Override
    public void write(@NotNull CLogDto aDto) {
        String message = this.getFormatter().format(aDto);
        if (aDto.getLevel().ordinal() == ELevel.ERROR.ordinal()) {
            System.err.println(message);
        } else {
            if (this.mUseColors) {
                message = this.useColors(message);
            }
            System.out.println(message);
        }
    }

    private String useColors(@NotNull String aText) {
        String txt = CUtilColoredWords.useColors(aText, GREEN_WORDS, "\u001b[32m");
        txt = CUtilColoredWords.useColors(txt, RED_WORDS, "\u001b[31m");
        txt = CUtilColoredWords.useColors(txt, LIGHT_CYAN_WORDS, "\u001b[96m");
        txt = CUtilColoredWords.useColors(txt, MAGENTA_WORDS, "\u001b[95m");
        return txt;
    }
}

