/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.target.listener.target;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.common.CWellKnownTID;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.namedb.INameDb;
import de.sillysky.nyssr.namespace.IRecordHelper;
import de.sillysky.nyssr.notification.records.CRecordNotifyNamespaceDeregistered;
import de.sillysky.nyssr.notification.records.CRecordNotifyRemoteNodeRemoved;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.listener.IListenerRegistry;
import de.sillysky.nyssr.target.registry.ITargetRegistry;
import de.sillysky.nyssr.target.registry.records.CRecordNotifyTargetDeregistered;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import org.jetbrains.annotations.NotNull;

final class CTargetForListenerRegistry
extends CTarget {
    private final IListenerRegistry mListenerRegistry;
    private final INameDb mNameDb;
    private final IRecordHelper mRecordHelper;

    CTargetForListenerRegistry(@NotNull ITargetRegistry aTargetRegistry, @NotNull INameDb aNameDb, @NotNull IRecordHelper aRecordHelper, @NotNull IListenerRegistry aListenerRegistry) throws CException {
        this.mListenerRegistry = aListenerRegistry;
        this.mNameDb = aNameDb;
        this.mRecordHelper = aRecordHelper;
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordNotifyRemoteNodeRemoved.ID, this::asyncNotifyRemoteNodeRemoved);
        this.addMessageHandler(CRecordNotifyTargetDeregistered.ID, this::asyncNotifyTargetDeregistered);
        this.addMessageHandler(CRecordNotifyNamespaceDeregistered.ID, this::asyncNotifyNamespaceDeregistered);
        this.addMessageHandler(null, this::asyncNullHandler);
        aTargetRegistry.registerTarget(this, CWellKnownTID.LISTENER_REGISTRY);
    }

    private boolean asyncNotifyNamespaceDeregistered(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        IId nid = CRecordNotifyNamespaceDeregistered.getNamespace(aRecord, null);
        this.mListenerRegistry.notifyLocalNamespaceRemoved(nid);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncNotifyRemoteNodeRemoved(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        CNodeAddress node = CRecordNotifyRemoteNodeRemoved.getRemoteNode(aRecord, null);
        this.mListenerRegistry.notifyNodeRemoved(node);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncNotifyTargetDeregistered(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        CTargetAddress address = CRecordNotifyTargetDeregistered.getAddress(aRecord, null);
        this.mListenerRegistry.notifyTargetRemoved(address);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncNullHandler(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        int resultCode;
        if (aEnvelope.isAnswer() && (resultCode = aEnvelope.getResultCode()) != 0 && resultCode != 2001) {
            CTargetAddress address = aEnvelope.getSender();
            this.mListenerRegistry.notifyTargetRemoved(address);
        }
        return true;
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        this.mNameDb.getTargetAddressDatabase().putName(this.getAddress(), "ListenerRegistry");
        this.mRecordHelper.addObserver(CRecordNotifyTargetDeregistered.class, this, false);
        this.mRecordHelper.addObserver(CRecordNotifyNamespaceDeregistered.class, this, false);
        this.mRecordHelper.addObserver(CRecordNotifyRemoteNodeRemoved.class, this, false);
        aEnvelope.setResultSuccess();
        return true;
    }

    public void deactivate() {
        this.deregisterTarget();
    }
}

