/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.slot;

import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISingleSlotTypeFactory;
import de.sillysky.nyssr.slot.ISlot;
import de.sillysky.nyssr.util.time.CUtilZonedDateTime;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CSlotZonedDateTime
implements ISlot,
ISingleSlotTypeFactory {
    @Nullable
    private final ZonedDateTime mValue;

    public CSlotZonedDateTime() {
        this.mValue = null;
    }

    public CSlotZonedDateTime(@Nullable ZonedDateTime aValue) {
        this.mValue = aValue;
    }

    public CSlotZonedDateTime(@NotNull List<?> aValue) {
        Object object = aValue.get(0);
        this.mValue = this.create(object);
    }

    public CSlotZonedDateTime(String aValue) {
        this.mValue = this.create(aValue);
    }

    public CSlotZonedDateTime(@NotNull DataInput aStream) throws IOException {
        this.mValue = CUtilZonedDateTime.fromStream(aStream);
    }

    private ZonedDateTime create(Object aValue) {
        ZonedDateTime result = null;
        if (aValue != null) {
            if (aValue instanceof ZonedDateTime) {
                result = (ZonedDateTime)aValue;
            } else if (aValue instanceof String) {
                result = ZonedDateTime.parse((String)aValue);
            }
        }
        return result;
    }

    @Override
    public ISlot fromObject(@NotNull CSlotType aType, @Nullable Object aValue) {
        if (this.getType().equals(aType)) {
            return new CSlotZonedDateTime(this.create(aValue));
        }
        return null;
    }

    @Override
    @Nullable
    public ISlot fromJson(@Nullable Object aValue, @NotNull Map<Integer, byte[]> aByteArrayStore) {
        if (aValue instanceof String) {
            ZonedDateTime zdt = CUtilZonedDateTime.fromIsoString((String)aValue);
            return new CSlotZonedDateTime(zdt);
        }
        return null;
    }

    @Override
    public boolean equals(Object aObj) {
        if (this == aObj) {
            return true;
        }
        if (aObj == null) {
            return false;
        }
        if (this.getClass() != aObj.getClass()) {
            return false;
        }
        CSlotZonedDateTime other = (CSlotZonedDateTime)aObj;
        return Objects.equals(this.mValue, other.mValue);
    }

    public ZonedDateTime get() {
        return this.mValue;
    }

    @Override
    @NotNull
    public Class<?> getClassOfProducedObject() {
        return ZonedDateTime.class;
    }

    @Override
    public ISlot copy() {
        return this;
    }

    public String getString() {
        if (this.mValue == null) {
            return "null";
        }
        return this.valueToString();
    }

    @Override
    @NotNull
    public CSlotType getType() {
        return CCommonSlotType.ZONED_DATE_TIME;
    }

    @Override
    public Object getValue() {
        return this.mValue;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.mValue);
    }

    @Override
    public boolean isContentEqualTo(Object aValue) {
        return this.equals(aValue);
    }

    @Override
    public ISlot readSlot(@NotNull DataInput aStream, @NotNull CSlotType aType) throws IOException {
        if (this.getType().equals(aType)) {
            return new CSlotZonedDateTime(aStream);
        }
        return null;
    }

    @Override
    public void toStream(@NotNull DataOutput aStream) throws IOException {
        CUtilZonedDateTime.toStream(aStream, this.mValue);
    }

    public String toString() {
        return this.getString();
    }

    @Override
    @NotNull
    public String valueToString() {
        if (this.mValue == null) {
            return "";
        }
        return this.mValue.format(DateTimeFormatter.ISO_ZONED_DATE_TIME);
    }

    @Override
    @Nullable
    public Object toJson(@NotNull Map<Integer, byte[]> aBinaries) {
        if (this.mValue != null) {
            return CUtilZonedDateTime.toIsoString(this.mValue);
        }
        return null;
    }
}

