/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.slot;

import de.sillysky.nyssr.json.CJsonArray;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISingleSlotTypeFactory;
import de.sillysky.nyssr.slot.ISlot;
import de.sillysky.nyssr.util.CUtilFloat;
import de.sillysky.nyssr.util.CUtilFloatArray;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CSlotFloatArray
implements ISlot,
ISingleSlotTypeFactory {
    private final float[] mValue;

    CSlotFloatArray() {
        this.mValue = null;
    }

    private CSlotFloatArray(float @Nullable [] aValue) {
        this.mValue = CUtilFloatArray.copy(aValue);
    }

    @NotNull
    private static CSlotFloatArray create(@Nullable Object aValue) {
        if (aValue instanceof float[]) {
            return new CSlotFloatArray((float[])aValue);
        }
        if (aValue instanceof String) {
            return CSlotFloatArray.fromString((String)aValue);
        }
        if (aValue instanceof List) {
            return CSlotFloatArray.fromList((List)aValue);
        }
        return new CSlotFloatArray();
    }

    @NotNull
    private static CSlotFloatArray fromList(@NotNull List<?> aList) {
        float[] array = CUtilFloatArray.fromList(aList);
        return new CSlotFloatArray(array);
    }

    @NotNull
    private static CSlotFloatArray fromStream(@NotNull DataInput aStream) throws IOException {
        float[] array = CUtilFloatArray.fromStream(aStream);
        return new CSlotFloatArray(array);
    }

    @NotNull
    private static CSlotFloatArray fromString(@NotNull String aValue) {
        float[] array = CUtilFloatArray.fromString(aValue);
        return new CSlotFloatArray(array);
    }

    @Override
    @Nullable
    public ISlot fromObject(@NotNull CSlotType aType, @Nullable Object aValue) {
        if (this.getType().equals(aType)) {
            return CSlotFloatArray.create(aValue);
        }
        return null;
    }

    @Override
    @Nullable
    public ISlot fromJson(@Nullable Object aValue, @NotNull Map<Integer, byte[]> aByteArrayStore) {
        if (aValue instanceof CJsonArray) {
            CJsonArray arr = (CJsonArray)aValue;
            float[] values = new float[arr.size()];
            int i = 0;
            for (Object child : arr.getChildren()) {
                float j;
                values[i] = j = CUtilFloat.fromObject(child, 0.0f);
                ++i;
            }
            return new CSlotFloatArray(values);
        }
        return null;
    }

    @Override
    public boolean equals(@Nullable Object aObj) {
        if (this == aObj) {
            return true;
        }
        if (aObj == null) {
            return false;
        }
        if (this.getClass() != aObj.getClass()) {
            return false;
        }
        CSlotFloatArray other = (CSlotFloatArray)aObj;
        return CUtilFloatArray.isEqual(this.mValue, other.mValue);
    }

    @Override
    @NotNull
    public Class<?> getClassOfProducedObject() {
        return float[].class;
    }

    @Override
    @NotNull
    public ISlot copy() {
        float[] value = CUtilFloatArray.copy(this.mValue);
        return new CSlotFloatArray(value);
    }

    @Override
    @NotNull
    public CSlotType getType() {
        return CCommonSlotType.FLOAT_ARRAY;
    }

    @Override
    @Nullable
    public Object getValue() {
        return this.mValue;
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.mValue);
    }

    @Override
    public boolean isContentEqualTo(@Nullable Object aValue) {
        if (this.mValue == aValue) {
            return true;
        }
        if (this.mValue != null && aValue != null && aValue instanceof float[]) {
            float[] ff = (float[])aValue;
            return CUtilFloatArray.isEqual(this.mValue, ff);
        }
        return false;
    }

    @Override
    @Nullable
    public ISlot readSlot(@NotNull DataInput aStream, @NotNull CSlotType aType) throws IOException {
        if (this.getType().equals(aType)) {
            return CSlotFloatArray.fromStream(aStream);
        }
        return null;
    }

    @Override
    public void toStream(@NotNull DataOutput aStream) throws IOException {
        CUtilFloatArray.toStream(aStream, this.mValue);
    }

    @NotNull
    public String toString() {
        return CUtilFloatArray.toString(this.mValue, ',', 1000);
    }

    @Override
    @NotNull
    public String valueToString() {
        return CUtilFloatArray.toString(this.mValue, ',', 0);
    }

    @Override
    @Nullable
    public Object toJson(@NotNull Map<Integer, byte[]> aBinaries) {
        if (this.mValue != null && this.mValue.length > 0) {
            CJsonArray arr = new CJsonArray();
            for (float i : this.mValue) {
                arr.add(Float.valueOf(i));
            }
            return arr;
        }
        return null;
    }
}

