/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.slot;

import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISingleSlotTypeFactory;
import de.sillysky.nyssr.slot.ISlot;
import de.sillysky.nyssr.util.swing.color.CUtilColor;
import java.awt.Color;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CSlotColor
implements ISlot,
ISingleSlotTypeFactory {
    @NotNull
    private final Color mValue;

    CSlotColor() {
        this.mValue = Color.WHITE;
    }

    private CSlotColor(@Nullable Color aValue) {
        this.mValue = aValue == null ? Color.WHITE : aValue;
    }

    @NotNull
    private static CSlotColor fromObject(@Nullable Object aValue) {
        if (aValue instanceof Color) {
            return new CSlotColor((Color)aValue);
        }
        if (aValue instanceof String) {
            return CSlotColor.fromString((String)aValue);
        }
        if (aValue instanceof List) {
            return CSlotColor.fromList((List)aValue);
        }
        return new CSlotColor();
    }

    @NotNull
    private static CSlotColor fromList(@NotNull List<?> aValue) {
        CSlotColor result;
        if (aValue.isEmpty()) {
            result = new CSlotColor();
        } else {
            Object object = aValue.get(0);
            result = CSlotColor.fromObject(object);
        }
        return result;
    }

    @NotNull
    private static CSlotColor fromStream(@NotNull DataInput aStream) throws IOException {
        Color value = CUtilColor.fromStream(aStream);
        return new CSlotColor(value);
    }

    @NotNull
    private static CSlotColor fromString(@NotNull String aValue) {
        Color value = CUtilColor.fromString(aValue);
        return new CSlotColor(value);
    }

    @Override
    @Nullable
    public ISlot fromObject(@NotNull CSlotType aType, @Nullable Object aValue) {
        if (this.getType().equals(aType)) {
            return CSlotColor.fromObject(aValue);
        }
        return null;
    }

    @Override
    @Nullable
    public ISlot fromJson(@Nullable Object aValue, @NotNull Map<Integer, byte[]> aByteArrayStore) {
        if (aValue instanceof String) {
            Color v = CUtilColor.fromHexWithAlpha((String)aValue);
            return new CSlotColor(v);
        }
        return null;
    }

    @Override
    public boolean equals(@Nullable Object aObj) {
        if (this == aObj) {
            return true;
        }
        if (aObj == null) {
            return false;
        }
        if (this.getClass() != aObj.getClass()) {
            return false;
        }
        CSlotColor other = (CSlotColor)aObj;
        return this.mValue.equals(other.mValue);
    }

    @Override
    @NotNull
    public Class<?> getClassOfProducedObject() {
        return Color.class;
    }

    @Override
    @NotNull
    public ISlot copy() {
        return this;
    }

    @Override
    @NotNull
    public CSlotType getType() {
        return CCommonSlotType.COLOR;
    }

    @Override
    @NotNull
    public Object getValue() {
        return this.mValue;
    }

    @Override
    public int hashCode() {
        return this.mValue.hashCode();
    }

    @Override
    public boolean isContentEqualTo(@Nullable Object aValue) {
        return this.mValue.equals(aValue);
    }

    @Override
    @Nullable
    public ISlot readSlot(@NotNull DataInput aStream, @NotNull CSlotType aType) throws IOException {
        if (this.getType().equals(aType)) {
            return CSlotColor.fromStream(aStream);
        }
        return null;
    }

    @Override
    public void toStream(@NotNull DataOutput aStream) throws IOException {
        CUtilColor.toStream(aStream, this.mValue);
    }

    @NotNull
    public String toString() {
        return this.mValue.toString();
    }

    @Override
    @NotNull
    public String valueToString() {
        return CUtilColor.toString(this.mValue);
    }

    @Override
    @NotNull
    public Object toJson(@NotNull Map<Integer, byte[]> aBinaries) {
        return CUtilColor.toHexWithAlpha(this.mValue);
    }
}

