/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.service;

import de.sillysky.nyssr.impl.service.IThreadPoolManager;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

class CThreadPoolManager
implements IThreadPoolManager {
    private final ExecutorService mPool;

    public CThreadPoolManager(int aNumberOfThreads) {
        this.mPool = Executors.newFixedThreadPool(aNumberOfThreads);
    }

    @Override
    public void submitJob(@NotNull Runnable job) {
        this.mPool.submit(job);
    }

    @Override
    public void shutdown() {
        this.mPool.shutdown();
        try {
            if (!this.mPool.awaitTermination(60L, TimeUnit.SECONDS)) {
                this.mPool.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.mPool.shutdownNow();
        }
    }

    @Override
    public void reset() {
    }
}

