/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.plugin;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.impl.service.CServiceRegistry;
import de.sillysky.nyssr.kernel.configuration.IKernelConfiguration;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.util.CUtilInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.jetbrains.annotations.NotNull;

public class CUtilPlugIn {
    private static final ILogger LOG = CLoggerFactory.getLogger(CUtilPlugIn.class);

    @NotNull
    public static List<String> loadPluginListFromPreferencesSubNode() {
        ArrayList<String> result = new ArrayList<String>();
        try {
            String[] keys;
            TreeMap<Integer, String> keyMap = new TreeMap<Integer, String>();
            Preferences preferences = CServiceRegistry.getInstance().getServiceOrThrow(IKernelConfiguration.class).getPreferences("plugin.manager/plugins");
            for (String key : keys = preferences.keys()) {
                int i;
                String v = preferences.get(key, "");
                if (v.isEmpty() || (i = CUtilInteger.fromString(key, -1)) < 0) continue;
                keyMap.put(i, v);
            }
            result.addAll(keyMap.values());
        }
        catch (BackingStoreException aE) {
            LOG.error((Throwable)aE, "Error loading PlugIn list from preferences");
        }
        catch (CException aE) {
            LOG.error((Throwable)aE, "No KernelConfiguration available");
        }
        return result;
    }

    private CUtilPlugIn() {
    }
}

