/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.nanoservice.monitor.target;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.address.filter.CTargetAddressFilter;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.common.CWellKnownTID;
import de.sillysky.nyssr.impl.nanoservice.monitor.target.records.CRecordTargetMonitorAddFilter;
import de.sillysky.nyssr.impl.nanoservice.monitor.target.records.CRecordTargetMonitorRemoveFilter;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.namespace.INamespaceRegistry;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.helper.CRecordHelper;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.monitor.ITargetMonitor;
import de.sillysky.nyssr.target.registry.ITargetRegistry;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import org.jetbrains.annotations.NotNull;

public final class CTargetForTargetMonitor
extends CTarget
implements IService {
    private static final String FILTER = "nid=SYSTEM";
    private static final ILogger LOG = CLoggerFactory.getLogger(CTargetForTargetMonitor.class);
    private INamespaceRegistry mNamespaceRegistry;

    static void addDependencies(IServiceDependencyList aDependencyList) {
        aDependencyList.add(INamespaceRegistry.class);
        aDependencyList.add(ITargetRegistry.class, FILTER);
    }

    @Override
    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        this.mNamespaceRegistry = aServiceRegistry.getService(INamespaceRegistry.class);
        LOG.debug("Activate {}", this.getClass().getSimpleName());
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordTargetMonitorAddFilter.ID, this::asyncAddTargetMonitorFilter);
        this.addMessageHandler(CRecordTargetMonitorRemoveFilter.ID, this::asyncRemoveTargetMonitorFilter);
        ITargetRegistry targetRegistry = aServiceRegistry.getService(ITargetRegistry.class, FILTER);
        assert (targetRegistry != null);
        targetRegistry.registerTarget(this, CWellKnownTID.TARGET_MONITOR);
    }

    private boolean asyncAddTargetMonitorFilter(CEnvelope aEnvelope, CRecord aRecord) {
        CTargetAddress[] ff;
        CTargetAddress f;
        IId nid = CRecordTargetMonitorAddFilter.getNid(aRecord, null);
        CUtilCheck.checkNotNull(nid, "Missing Namespace ID", new Object[0]);
        INamespace ns = this.mNamespaceRegistry.getNamespace(nid);
        CUtilCheck.checkNotNull(ns, "Namespace %s not found", nid);
        ITargetMonitor monitor = ns.getTargetRegistry().getMonitor();
        CTargetAddress observer = CRecordTargetMonitorAddFilter.getObserver(aRecord, aEnvelope.getSender());
        CUtilCheck.checkNotNull(observer, "Missing observer", new Object[0]);
        boolean removeOld = CRecordTargetMonitorAddFilter.getRemoveOld(aRecord, false);
        if (removeOld) {
            monitor.removeObserver(observer);
        }
        if ((f = CRecordTargetMonitorAddFilter.getFilter(aRecord, null)) != null) {
            CTargetAddressFilter filter = new CTargetAddressFilter(f);
            monitor.addObserver(observer, filter);
        }
        if ((ff = CRecordTargetMonitorAddFilter.getFilters(aRecord, null)) != null) {
            for (CTargetAddress address : ff) {
                CTargetAddressFilter filter = new CTargetAddressFilter(address);
                monitor.addObserver(observer, filter);
            }
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncRemoveTargetMonitorFilter(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        IId nid = CRecordTargetMonitorRemoveFilter.getNid(aRecord, null);
        CUtilCheck.checkNotNull(nid, "Missing Namespace ID", new Object[0]);
        INamespace ns = this.mNamespaceRegistry.getNamespace(nid);
        CUtilCheck.checkNotNull(ns, "Namespace %s not found", nid);
        ITargetMonitor monitor = ns.getTargetRegistry().getMonitor();
        CTargetAddress observer = CRecordTargetMonitorRemoveFilter.getObserver(aRecord, aEnvelope.getSender());
        CUtilCheck.checkNotNull(observer, "Missing observer", new Object[0]);
        boolean removeAll = CRecordTargetMonitorRemoveFilter.getRemoveAll(aRecord, false);
        if (removeAll) {
            monitor.removeObserver(observer);
        } else {
            CTargetAddress[] filters;
            CTargetAddress f = CRecordTargetMonitorRemoveFilter.getFilter(aRecord, null);
            if (f != null) {
                monitor.removeFilter(observer, new CTargetAddressFilter(f));
            }
            if ((filters = CRecordTargetMonitorRemoveFilter.getFilters(aRecord, null)) != null) {
                for (CTargetAddress filter : filters) {
                    monitor.removeFilter(observer, new CTargetAddressFilter(filter));
                }
            }
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncStartTarget(CEnvelope aEnvelope, CRecord aRecord) throws CException {
        CRecordHelper.addObserver(CRecordTargetMonitorAddFilter.class, this, false);
        CRecordHelper.addObserver(CRecordTargetMonitorRemoveFilter.class, this, false);
        aEnvelope.setResultSuccess();
        return true;
    }

    @Override
    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        LOG.debug("Deactivate {}", this.getClass().getSimpleName());
        this.deregisterTarget();
    }
}

