/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.nanoservice;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.common.CWellKnownTID;
import de.sillysky.nyssr.impl.nanoservice.CNanoServiceRegistry;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.message.CMessage;
import de.sillysky.nyssr.message.hook.EMessageHookCause;
import de.sillysky.nyssr.nanoservice.INanoServiceEntry;
import de.sillysky.nyssr.nanoservice.records.CRecordNanoServiceGetServiceInfo;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.util.CUtilString;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CNanoServiceEntry
implements INanoServiceEntry {
    private static final ILogger LOG = CLoggerFactory.getLogger(CNanoServiceEntry.class);
    private static final ILogger LOG1 = CLoggerFactory.getLogger("NoObserver");
    private static final IId OBSERVER_SENDER_TARGET_ID = CWellKnownTID.SYSTEM;
    @NotNull
    private final UUID mListenerId = UUID.randomUUID();
    @NotNull
    private final IId mSID;
    @NotNull
    private final CNanoServiceRegistry mRegistry;
    private final AtomicReference<CMessage> mLastTrigger = new AtomicReference<Object>(null);
    @NotNull
    private String mName;

    CNanoServiceEntry(@NotNull CNanoServiceRegistry aRegistry, @NotNull IId aSID, @NotNull String aName) {
        this.mRegistry = aRegistry;
        this.mSID = aSID;
        this.mName = aName;
    }

    void addObserver(@NotNull CTargetAddress aObserver, boolean aRecallTrigger) throws CException {
        CMessage last;
        if (!this.mRegistry.getListenerRegistry().addAddress(this.mListenerId, aObserver)) {
            throw new CException(16).append("Observer already registered.");
        }
        String name = this.mName;
        if (CUtilString.isEmpty(name)) {
            name = this.mSID.toString();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("    Observer added {} to NanoService {} in namespace {}.", aObserver.toString(), name, this.mRegistry.getNID().toString());
        }
        if ((last = this.mLastTrigger.get()) != null && aRecallTrigger) {
            CMessage evSend = this.createMessage(last.getEnvelope(), last.getRecord(), aObserver);
            this.mRegistry.send(evSend);
        }
    }

    private CMessage createMessage(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord, @Nullable CTargetAddress aObserver) {
        CEnvelope env = CEnvelope.copy(aEnvelope);
        CRecord rec = new CRecord(aRecord);
        CTargetAddress sender = env.getSender();
        if (!sender.getTID().isValid()) {
            CTargetAddress newSender = new CTargetAddress(OBSERVER_SENDER_TARGET_ID, sender.getNID(), sender.getNodeAddress());
            env.setSender(newSender);
        }
        env.setReceiver(aObserver);
        rec.setId(this.mSID);
        return new CMessage(env, rec);
    }

    public boolean equals(Object aOther) {
        if (this == aOther) {
            return true;
        }
        if (aOther == null) {
            return false;
        }
        if (!(aOther instanceof CNanoServiceEntry)) {
            return false;
        }
        CNanoServiceEntry other = (CNanoServiceEntry)aOther;
        return this.mSID == other.mSID;
    }

    @Override
    @NotNull
    public IId getID() {
        return this.mSID;
    }

    @NotNull
    private CMessage getLastTrigger() {
        return this.mLastTrigger.get();
    }

    @Override
    @NotNull
    public IId getNID() {
        return this.mRegistry.getNID();
    }

    @Override
    @NotNull
    public String getName() {
        return this.mName;
    }

    void setName(@NotNull String aName) {
        if (!aName.isEmpty()) {
            this.mName = aName;
        }
    }

    @Override
    public int getObserverCount() {
        return this.mRegistry.getListenerRegistry().getNumberOfListener(this.mListenerId);
    }

    void getServiceInfo(@NotNull CRecord aRecord) throws CException {
        CTargetAddress[] observers = this.mRegistry.getListenerRegistry().getAddresses(this.mListenerId);
        CRecordNanoServiceGetServiceInfo.setExist(aRecord, true);
        CRecordNanoServiceGetServiceInfo.setLastTrigger(aRecord, this.getLastTrigger());
        CRecordNanoServiceGetServiceInfo.setName(aRecord, this.mName);
        CRecordNanoServiceGetServiceInfo.setObservers(aRecord, observers);
        CRecordNanoServiceGetServiceInfo.setSid(aRecord, this.mSID);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.mSID.hashCode();
        return result;
    }

    void recallTrigger() {
        CMessage last = this.mLastTrigger.get();
        if (last == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Warning during recallTrigger: nothing to recall. SID={}", this.mSID);
            }
        } else {
            CMessage msg = this.getLastTrigger();
            this.triggerObserver(msg);
        }
    }

    void recallTrigger(@NotNull CTargetAddress aAddress) throws CException {
        CMessage last = this.mLastTrigger.get();
        if (last == null) {
            if (LOG.isDebugEnabled()) {
                LOG.warn("Warning during recallTrigger: nothing to recall. SID={}", this.mSID);
            }
        } else {
            CMessage evSend = this.createMessage(last.getEnvelope(), last.getRecord(), aAddress);
            this.mRegistry.send(evSend);
        }
    }

    void removeAllObserver() {
        this.mRegistry.getListenerRegistry().clear(this.mListenerId);
    }

    boolean removeObserver(@NotNull CTargetAddress aObserver) {
        boolean result = this.mRegistry.getListenerRegistry().removeAddress(this.mListenerId, aObserver);
        if (result && LOG.isDebugEnabled()) {
            LOG.debug("Observer {} removed from SID {}-{}", aObserver, this.mSID, this.mName);
        }
        return result;
    }

    private void storeMessage(@NotNull CMessage aMsg) {
        CEnvelope env1 = aMsg.getEnvelope();
        CEnvelope env2 = CEnvelope.copy(env1);
        env2.setTransactionId(null);
        env2.setWantAnswer(false);
        CRecord rec1 = aMsg.getRecord();
        CRecord rec2 = new CRecord(rec1);
        this.mLastTrigger.set(new CMessage(env2, rec2));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(100);
        sb.append("Service ");
        sb.append(this.mSID);
        sb.append(": ");
        sb.append(this.getObserverCount());
        sb.append(" observers");
        CMessage last = this.mLastTrigger.get();
        if (last != null) {
            sb.append(", LastSender=");
            sb.append(last.getEnvelope().getSender());
            sb.append(", LastRecord=");
            sb.append(last.getRecord());
        }
        return sb.toString();
    }

    boolean triggerObserver(@NotNull CMessage aTemplate) {
        int size;
        boolean logDone = false;
        this.storeMessage(aTemplate);
        if (aTemplate.getEnvelope().isLogEnabled() && LOG.isDebugEnabled()) {
            LOG.debug("Trigger {} Observer {}: {}", this.getObserverCount(), this.mName, aTemplate);
            logDone = true;
        }
        if ((size = this.mRegistry.getListenerRegistry().getNumberOfListener(this.mListenerId)) == 0) {
            if (!logDone && LOG1.isDebugEnabled()) {
                LOG1.debug("0 Observer found {}", aTemplate);
            }
            this.mRegistry.getMessageHookRegistry().invokeMessageHook(aTemplate, EMessageHookCause.NANOSERVICE_NO_OBSERVER);
            return false;
        }
        CMessage evSend = this.createMessage(aTemplate.getEnvelope(), aTemplate.getRecord(), null);
        this.mRegistry.getListenerRegistry().sendRequest(this.mListenerId, evSend);
        return true;
    }
}

