/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.json.writer;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.json.CJsonArray;
import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.json.IJsonCompactWriter;
import de.sillysky.nyssr.json.IJsonParser;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.json.simple.JSONObject;

public class CJsonCompactCompactWriter
implements IService,
IJsonCompactWriter {
    private static final ILogger LOG = CLoggerFactory.getLogger(CJsonCompactCompactWriter.class);
    private IJsonParser mParser;

    @Override
    public void activate(@NotNull IServiceRegistry aServiceRegistry) {
        this.mParser = aServiceRegistry.getService(IJsonParser.class);
        aServiceRegistry.registerService(IJsonCompactWriter.class, this);
    }

    @Override
    @NotNull
    public String rewrite(@NotNull String aText) throws CException {
        StringBuilder sb = new StringBuilder();
        CJsonObject obj = this.mParser.parse(aText, false);
        this.write(sb, obj);
        return sb.toString();
    }

    @Override
    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        aServiceRegistry.deregisterService(this);
    }

    @Override
    public void write(@NotNull StringBuilder aSb, @NotNull Object aObject) {
        if (aObject instanceof CJsonObject) {
            this.writeObject(aSb, (CJsonObject)aObject);
        } else if (aObject instanceof CJsonArray) {
            CJsonArray array = (CJsonArray)aObject;
            this.writeArray(aSb, array);
        } else if (aObject instanceof Boolean || aObject instanceof Number) {
            aSb.append(aObject);
        } else if (aObject instanceof Character) {
            aSb.append('\"').append(aObject).append('\"');
        } else if (aObject instanceof String) {
            aSb.append('\"').append((String)aObject).append('\"');
        } else {
            LOG.error("Can't write Object to JSON: Unsupported type {}", aObject.getClass().getName());
        }
    }

    private void writeArray(@NotNull StringBuilder aSb, @NotNull CJsonArray aArray) {
        aSb.append('[');
        int size = aArray.size();
        for (int i = 0; i < size; ++i) {
            Object o = aArray.getValue(i);
            o = this.escape(o);
            this.write(aSb, o);
            if (i >= size - 1) continue;
            aSb.append(',');
        }
        aSb.append(']');
    }

    private void writeObject(@NotNull StringBuilder aSb, @NotNull CJsonObject aObj) {
        aSb.append('{');
        int size = aObj.size();
        int i = 0;
        Collection<String> keys = aObj.keys();
        for (String key : keys) {
            Object value = aObj.getValue(key);
            if (value == null) continue;
            value = this.escape(value);
            aSb.append('\"').append(key).append('\"').append(":");
            this.write(aSb, value);
            if (i < size - 1) {
                aSb.append(',');
            }
            ++i;
        }
        aSb.append('}');
    }

    @NotNull
    private Object escape(@NotNull Object aValue) {
        Object result = aValue;
        if (aValue instanceof String) {
            result = JSONObject.escape((String)aValue);
        }
        return result;
    }
}

