/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.id.widget;

import de.sillysky.nyssr.id.widget.CWidgetId;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.key.CUtilNormalize;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CWidgetSetId {
    private final String mName;
    private final String mInstance;

    private CWidgetSetId(@NotNull String aName, @Nullable String aInstance) {
        this.mName = aName;
        this.mInstance = aInstance;
    }

    @NotNull
    public static String valueToString(@Nullable CWidgetSetId aValue) {
        if (aValue == null) {
            return "null";
        }
        return aValue.valueToString();
    }

    @Nullable
    public static CWidgetSetId valueFromString(@Nullable String aValue) {
        if (CUtilString.isEmpty(aValue) || ".".equals(aValue)) {
            return null;
        }
        return CWidgetSetId.create(aValue);
    }

    public static void toStream(@NotNull DataOutput aStream, @Nullable CWidgetSetId aValue) throws IOException {
        String value = CWidgetSetId.valueToString(aValue);
        CUtilString.toStream(aStream, value);
    }

    @Nullable
    public static CWidgetSetId fromStream(@NotNull DataInput aStream) throws IOException {
        String s = CUtilString.fromStream(aStream);
        if (CUtilString.isEmpty(s) || ".".equals(s)) {
            return null;
        }
        return CWidgetSetId.valueFromString(s);
    }

    @NotNull
    public static CWidgetSetId create(@Nullable String aName, @Nullable String aInstance) {
        String widgetSetName = CUtilNormalize.normalize(aName);
        String instance = CUtilNormalize.normalize(aInstance);
        return new CWidgetSetId(widgetSetName, instance);
    }

    @Nullable
    private static CWidgetSetId create(@Nullable String aValue) {
        if (CUtilString.isEmpty(aValue)) {
            return null;
        }
        String[] split = aValue.split("[.]");
        String name = null;
        String inst = null;
        if (split.length >= 1) {
            name = split[0];
        }
        if (split.length >= 2) {
            inst = split[1];
        }
        return name == null ? null : CWidgetSetId.create(name, inst);
    }

    @NotNull
    public String getName() {
        return this.mName;
    }

    public boolean equals(Object aOther) {
        if (this == aOther) {
            return true;
        }
        if (aOther == null || this.getClass() != aOther.getClass()) {
            return false;
        }
        CWidgetSetId cWidgetId = (CWidgetSetId)aOther;
        return Objects.equals(this.mName, cWidgetId.mName) && Objects.equals(this.mInstance, cWidgetId.mInstance);
    }

    public int hashCode() {
        return Objects.hash(this.mName, this.mInstance);
    }

    @NotNull
    public String getInstance() {
        return this.mInstance == null ? "" : this.mInstance;
    }

    public String valueToString() {
        return this.mName + "." + this.mInstance;
    }

    public String toString() {
        return this.valueToString();
    }

    public boolean isValid() {
        return CUtilString.isValid(this.mName);
    }

    @NotNull
    public CWidgetId createWidgetId(@NotNull String aWidgetName) {
        return CWidgetId.create(aWidgetName, this);
    }
}

