/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.id.string;

import de.sillysky.nyssr.id.EIdType;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.IIdFactory;
import de.sillysky.nyssr.id.string.CIdString;
import de.sillysky.nyssr.impl.service.CServiceRegistry;
import de.sillysky.nyssr.unique.integer.IUniqueInteger;
import de.sillysky.nyssr.util.CUtilString;
import java.io.DataInput;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CIdStringFactory
implements IIdFactory {
    CIdStringFactory() {
    }

    @Override
    public IId fromObject(Object aObj) {
        String s;
        if (aObj instanceof String && !(s = (String)aObj).isEmpty()) {
            return new CIdString(s);
        }
        return null;
    }

    @Override
    @NotNull
    public IId random() {
        return new CIdString(CUtilString.random(20));
    }

    @NotNull
    public IId random(@Nullable String aPrefix) {
        IUniqueInteger ui = CServiceRegistry.getInstance().getService(IUniqueInteger.class);
        assert (ui != null);
        return new CIdString(aPrefix + "-" + ui.getNext("StringId"));
    }

    @Override
    @NotNull
    public IId fromStream(@NotNull DataInput aStream) throws IOException {
        String str = CUtilString.fromStream(aStream);
        if (!CUtilString.isEmpty(str)) {
            return new CIdString(str);
        }
        return IId.INVALID;
    }

    @Override
    @NotNull
    public EIdType getType() {
        return EIdType.STRING;
    }
}

