/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.exception;

import de.sillysky.nyssr.result.CResult;
import org.jetbrains.annotations.NotNull;

public class CException
extends Exception {
    private static final long serialVersionUID = 23822759292983092L;
    private final int mCode;
    private final StringBuilder mStringBuilder = new StringBuilder(100);
    private String mText = null;

    public CException(@NotNull CResult aError) {
        this.mCode = aError.getCode();
        this.mStringBuilder.append(aError.getText());
        this.mText = null;
    }

    public CException(int aCode) {
        this.mCode = aCode;
    }

    public CException(Throwable aException) {
        super(aException);
        this.mCode = 2;
    }

    public CException append(boolean aValue) {
        this.mStringBuilder.append(aValue);
        this.mText = null;
        return this;
    }

    public CException append(byte aValue) {
        this.mStringBuilder.append(aValue);
        this.mText = null;
        return this;
    }

    public CException append(char aValue) {
        this.mStringBuilder.append(aValue);
        this.mText = null;
        return this;
    }

    public CException append(double aValue) {
        this.mStringBuilder.append(aValue);
        this.mText = null;
        return this;
    }

    public CException append(float aValue) {
        this.mStringBuilder.append(aValue);
        this.mText = null;
        return this;
    }

    public CException append(int aValue) {
        this.mStringBuilder.append(aValue);
        this.mText = null;
        return this;
    }

    public CException append(long aValue) {
        this.mStringBuilder.append(aValue);
        this.mText = null;
        return this;
    }

    public CException append(Object aObj) {
        this.mStringBuilder.append(aObj);
        this.mText = null;
        return this;
    }

    public CException append(short aValue) {
        this.mStringBuilder.append(aValue);
        this.mText = null;
        return this;
    }

    public CException append(String aValue) {
        this.mStringBuilder.append(aValue);
        this.mText = null;
        return this;
    }

    public int getCode() {
        return this.mCode;
    }

    public String getCombinedText() {
        String msg = this.toString();
        return this.mCode + ": " + msg;
    }

    public CResult getError() {
        return new CResult(this.mCode, this.toString());
    }

    @Override
    public String getLocalizedMessage() {
        return this.toString();
    }

    @Override
    public String getMessage() {
        return this.toString();
    }

    @Override
    public String toString() {
        if (this.mText == null) {
            this.mText = this.mStringBuilder.toString();
        }
        return this.mText;
    }
}

