/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.address.filter;

import de.sillysky.nyssr.address.CNodeId;
import de.sillysky.nyssr.address.CSegmentId;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CTargetAddressFilter {
    private final IId mTID;
    private final IId mNID;
    private final CNodeId mNodeId;
    private final CSegmentId mSegmentId;

    public CTargetAddressFilter(@Nullable IId aTID, @Nullable IId aNID, @Nullable CNodeId aNodeId, @Nullable CSegmentId aSegmentId) {
        this.mTID = aTID;
        this.mNID = aNID;
        this.mNodeId = aNodeId;
        this.mSegmentId = aSegmentId;
    }

    public CTargetAddressFilter(@NotNull CTargetAddress aAddress) {
        this.mTID = aAddress.getTID();
        this.mNID = aAddress.getNID();
        this.mNodeId = aAddress.getNodeId();
        this.mSegmentId = aAddress.getSegmentId();
    }

    @NotNull
    public static CTargetAddressFilter fromObject(@Nullable Object aTID, @Nullable Object aNID, @Nullable Object aNodeId, @Nullable Object aSegmentId) {
        IId tid = CIdFactory.fromObject(aTID);
        IId nid = CIdFactory.fromObject(aNID);
        CNodeId nodeId = new CNodeId(CIdFactory.fromObject(aNodeId));
        CSegmentId segmentId = new CSegmentId(CIdFactory.fromObject(aSegmentId));
        return new CTargetAddressFilter(tid, nid, nodeId, segmentId);
    }

    @Nullable
    public IId getTID() {
        return this.mTID;
    }

    @Nullable
    public IId getNID() {
        return this.mNID;
    }

    @Nullable
    public CNodeId getNodeId() {
        return this.mNodeId;
    }

    @Nullable
    public CSegmentId getSegmentId() {
        return this.mSegmentId;
    }

    public boolean equals(@Nullable Object aOther) {
        if (this == aOther) {
            return true;
        }
        if (aOther == null || this.getClass() != aOther.getClass()) {
            return false;
        }
        CTargetAddressFilter that = (CTargetAddressFilter)aOther;
        return Objects.equals(this.mTID, that.mTID) && Objects.equals(this.mNID, that.mNID) && Objects.equals(this.mNodeId, that.mNodeId) && Objects.equals(this.mSegmentId, that.mSegmentId);
    }

    public int hashCode() {
        return Objects.hash(this.mTID, this.mNID, this.mNodeId, this.mSegmentId);
    }
}

