/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.app.manager;

import de.sillysky.nyssr.app.IApplicationInstance;
import de.sillysky.nyssr.app.records.CRecordAppStopApplication;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.app.instance.registry.CAppInstanceEntry;
import de.sillysky.nyssr.impl.app.manager.IDependencies;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.login.records.CRecordSessionValidate;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.session.CConstantsSession;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.CUtilUuid;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CUtilSession {
    private CUtilSession() {
    }

    static void sendValidateToken(@NotNull CTarget aTarget, @Nullable String aSessionToken) throws CException {
        CEnvelope env = CEnvelope.forMicroService((IId)CConstantsSession.MICRO_SERVICE_ID);
        CRecord record = CRecordSessionValidate.create();
        CRecordSessionValidate.setToken((CRecord)record, (String)aSessionToken);
        aTarget.sendRequest(env, record);
    }

    static boolean findRight(@Nullable String aRight, @NotNull String[] aRights) {
        if (CUtilString.isEmpty((String)aRight)) {
            return true;
        }
        for (String right : aRights) {
            if (!aRight.equalsIgnoreCase(right)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    static String checkSessionToken(@NotNull CRecord aRecord) throws CException {
        String sessionToken = CRecordAppStopApplication.getSessionToken((CRecord)aRecord, null);
        if (CUtilString.isEmpty((String)sessionToken)) {
            throw new CException(7).append("Invalid session token.");
        }
        return sessionToken;
    }

    @NotNull
    static UUID checkInstanceId(@NotNull CRecord aRecord) throws CException {
        UUID instanceId = CRecordAppStopApplication.getInstanceId((CRecord)aRecord, null);
        if (CUtilUuid.isEmpty((UUID)instanceId)) {
            throw new CException(7).append("Invalid instance ID.");
        }
        return instanceId;
    }

    @NotNull
    static CAppInstanceEntry findEntry(@NotNull IDependencies aDependencies, @NotNull UUID aInstanceId) throws CException {
        CAppInstanceEntry entry = aDependencies.getInternalApplicationInstanceRegistry().getEntry(aInstanceId);
        if (entry == null) {
            throw new CException(5).append("Application instance not found.");
        }
        return entry;
    }

    static void logApps(@NotNull IDependencies aDependencies, @NotNull ILogger aLogger, @NotNull UUID aInstanceId, @NotNull IId aNid, @NotNull IApplicationInstance aInstance, @NotNull String aAction) {
        if (aLogger.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder(1000);
            sb.append(CUtilString.LINE_CRLF);
            sb.append("# Application ").append(aAction).append(":\n");
            sb.append("# Name              :").append(aInstance.getApplicationName()).append(CUtilString.CRLF);
            sb.append("# Application ID    :").append(aInstance.getApplicationId()).append(CUtilString.CRLF);
            sb.append("# Instance ID       :").append(aInstanceId).append(CUtilString.CRLF);
            sb.append("# Namespace ID      :").append(aNid).append(CUtilString.CRLF);
            sb.append("# Description       :").append(aInstance.getShortDescription()).append(CUtilString.CRLF);
            sb.append("# Preset Name       :").append(aInstance.getPresetName()).append(CUtilString.CRLF);
            sb.append(CUtilString.LINE_CRLF);
            aLogger.info(sb.toString());
        }
        aDependencies.getApplicationInstanceRegistry().dump();
    }
}

