/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.app.manager;

import de.sillysky.nyssr.app.EShutDownMode;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.impl.app.instance.registry.CAppInstanceEntry;
import de.sillysky.nyssr.impl.app.manager.CUtilSession;
import de.sillysky.nyssr.impl.app.manager.CUtilStopper;
import de.sillysky.nyssr.impl.app.manager.IDependencies;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.login.records.CRecordSessionValidate;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.result.CResult;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

class CAppStopperTarget
extends CTarget {
    private static final ILogger LOG = CLoggerFactory.getLogger(CAppStopperTarget.class);
    private final IDependencies mDependencies;
    private final CEnvelope mEnvelope;
    private final CRecord mRecord;
    private String mSessionToken;
    private UUID mInstanceId;
    private CAppInstanceEntry mEntry;
    private EShutDownMode mShutDownMode;

    CAppStopperTarget(@NotNull IDependencies aDependencies, @NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        this.mDependencies = aDependencies;
        this.mEnvelope = aEnvelope;
        this.mRecord = aRecord;
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordSessionValidate.ID, this::asyncAnswerSessionValidate);
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        try {
            this.mSessionToken = CUtilSession.checkSessionToken(this.mRecord);
            this.mInstanceId = CUtilSession.checkInstanceId(this.mRecord);
            this.mShutDownMode = CUtilStopper.getShutDownMode(this.mRecord);
            this.mEntry = CUtilSession.findEntry(this.mDependencies, this.mInstanceId);
            if (this.isSameUser()) {
                CUtilStopper.stopApplication(this.mDependencies, this, this.mEntry, this.mShutDownMode, LOG, this.mEntry.getUserId());
            } else {
                CUtilSession.sendValidateToken(this, this.mSessionToken);
            }
        }
        catch (CException e) {
            this.finish(e.getCode(), e.getMessage());
        }
        catch (Exception e) {
            this.finish(2, e.getMessage());
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncAnswerSessionValidate(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            CResult result = aEnvelope.getResult();
            if (!result.hasSuccess()) {
                return this.finish(result.getCode(), result.getText());
            }
            String userId = CRecordSessionValidate.getUserId((CRecord)aRecord, null);
            String[] rights = CRecordSessionValidate.getRights((CRecord)aRecord, null);
            boolean allowed = CUtilSession.findRight("STOP_APPLICATIONS", rights);
            if (allowed) {
                try {
                    CUtilStopper.stopApplication(this.mDependencies, this, this.mEntry, this.mShutDownMode, LOG, userId);
                    this.finish(0, "");
                }
                catch (CException e) {
                    LOG.error((Throwable)e, "Error stopping application {}", new Object[]{this.mInstanceId});
                    this.mEnvelope.setResult(e.getCode(), e.getMessage());
                }
                catch (Exception e) {
                    LOG.error((Throwable)e, "Error stopping application {}", new Object[]{this.mInstanceId});
                    this.mEnvelope.setResult(2, e.getMessage());
                }
            } else {
                this.finish(5105, "Missing Rights");
            }
            this.mEnvelope.setResultSuccess();
            return true;
        }
        return false;
    }

    private boolean isSameUser() {
        return this.mEntry.getInstance().getSessionToken().equals(this.mSessionToken);
    }

    private boolean finish(int aCode, String aText) throws CException {
        this.mEnvelope.setBlocked(false);
        this.mEnvelope.setResult(aCode, aText);
        this.getMessageSender().sendBack(this.mEnvelope, this.mRecord);
        this.deregisterTarget();
        return true;
    }
}

