/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.app.factory.registry.target;

import de.sillysky.nyssr.app.IApplicationDescription;
import de.sillysky.nyssr.app.IApplicationFactoryRegistry;
import de.sillysky.nyssr.app.records.CRecordAppGetDescriptionById;
import de.sillysky.nyssr.app.records.CRecordAppGetSupportedApplications;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.common.CWellKnownTID;
import de.sillysky.nyssr.impl.app.CUtilApplication;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.namedb.INameDb;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.namespace.INamespaceFactory;
import de.sillysky.nyssr.namespace.IRecordHelper;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import java.util.Collection;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

final class CTargetForApplicationFactoryRegistry
extends CTarget
implements IService {
    private IApplicationFactoryRegistry mRegistry;
    private IRecordHelper mRecordHelper;
    private INameDb mNameDb;

    CTargetForApplicationFactoryRegistry() {
    }

    static void addDependencies(IServiceDependencyList aDependencyList) {
        aDependencyList.add(INamespaceFactory.class);
        aDependencyList.add(IRecordHelper.class);
        aDependencyList.add(INameDb.class);
        aDependencyList.add(IApplicationFactoryRegistry.class);
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        this.mRecordHelper = (IRecordHelper)aServiceRegistry.getService(IRecordHelper.class);
        this.mRegistry = (IApplicationFactoryRegistry)aServiceRegistry.getService(IApplicationFactoryRegistry.class);
        this.mNameDb = (INameDb)aServiceRegistry.getService(INameDb.class);
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordAppGetSupportedApplications.ID, this::asyncGetSupportedApplications);
        this.addMessageHandler(CRecordAppGetDescriptionById.ID, this::asyncGetApplicationDescriptionById);
        INamespace ns = CUtilApplication.getOrCreateNamespace();
        ns.getTargetRegistry().registerTarget((ITarget)this, CWellKnownTID.APPLICATION_FACTORY_REGISTRY);
    }

    private boolean asyncGetApplicationDescriptionById(CEnvelope aEnvelope, CRecord aRecord) throws CException {
        UUID applicationID = CRecordAppGetDescriptionById.getApplicationId((CRecord)aRecord, null);
        IApplicationDescription desc = this.mRegistry.getDescriptionByID(applicationID);
        if (desc == null) {
            aEnvelope.setResult(5, "Not Found");
        } else {
            CRecord rec = desc.toRecord();
            CRecordAppGetDescriptionById.setApplicationDescription((CRecord)aRecord, (CRecord)rec);
            aEnvelope.setResultSuccess();
        }
        return true;
    }

    private boolean asyncGetSupportedApplications(CEnvelope aEnvelope, CRecord aRecord) throws CException {
        Collection aa1 = this.mRegistry.getSupportedApplications();
        CRecord[] arr = new CRecord[aa1.size()];
        int i = 0;
        for (IApplicationDescription d : aa1) {
            arr[i] = d.toRecord();
            ++i;
        }
        CRecordAppGetSupportedApplications.setApplications((CRecord)aRecord, (CRecord[])arr);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncStartTarget(CEnvelope aEnvelope, CRecord aRecord) throws CException {
        this.mNameDb.getTargetAddressDatabase().putName(this.getAddress(), "AppFactoryReg");
        this.mRecordHelper.addObserver(CRecordAppGetSupportedApplications.class, (ITarget)this, false);
        this.mRecordHelper.addObserver(CRecordAppGetDescriptionById.class, (ITarget)this, false);
        aEnvelope.setResultSuccess();
        return true;
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        this.deregisterTarget();
    }
}

