/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.app.autostart;

import de.sillysky.nyssr.app.IApplicationPreset;
import de.sillysky.nyssr.util.CUtilUuid;
import java.time.LocalDateTime;
import java.util.UUID;

class CAutoStartEntry {
    static final long NO_START = -1L;
    private final UUID mTransactionId;
    private final IApplicationPreset mPreset;
    private LocalDateTime mStartTime;
    private boolean mStarted = false;
    private int mStartCounter = 0;

    CAutoStartEntry(IApplicationPreset aPreset, LocalDateTime aStartTime) {
        this.mPreset = aPreset;
        this.mStartTime = aStartTime;
        this.mTransactionId = CUtilUuid.random();
    }

    IApplicationPreset getPreset() {
        return this.mPreset;
    }

    public boolean shouldStart() {
        return !this.mStarted && LocalDateTime.now().compareTo(this.mStartTime) > 0;
    }

    public void setStarted(boolean aStarted) {
        this.mStarted = aStarted;
        if (!this.mStarted) {
            ++this.mStartCounter;
            this.mStartTime = LocalDateTime.now().plusSeconds(5L * (long)this.mStartCounter);
        }
    }

    public UUID getTransactionId() {
        return this.mTransactionId;
    }
}

