/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.server.dialog;

import de.sillysky.nyssr.address.CNodeId;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.widget.CWidgetId;
import de.sillysky.nyssr.impl.service.CServiceRegistry;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.message.CRoutingHint;
import de.sillysky.nyssr.network.hints.IRoutingHintRegistry;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.remoteskin.server.connector.CClientContextDto;
import de.sillysky.nyssr.remoteskin.server.connector.IRemoteSkinClientContext;
import de.sillysky.nyssr.remoteskin.server.dialog.CDialogDto;
import de.sillysky.nyssr.remoteskin.server.dialog.records.CRecordOpenDialog;
import org.jetbrains.annotations.NotNull;

public class CUtilDialogHelper {
    private CUtilDialogHelper() {
    }

    public static void enrichOpenDialogRecord(@NotNull CRecord aRecord, @NotNull IRemoteSkinClientContext aClientContext, @NotNull CWidgetId aParentWidget, @NotNull String aSessionToken) throws CException {
        CRecordOpenDialog.setClientContextAddress(aRecord, aClientContext.getTargetAddress());
        CRecordOpenDialog.setClientContextId(aRecord, aClientContext.getId());
        CRecordOpenDialog.setPlatformType(aRecord, aClientContext.getPlatformType());
        CRecordOpenDialog.setParentWidgetId(aRecord, aParentWidget);
        CRecordOpenDialog.setSessionToken(aRecord, aSessionToken);
        IRoutingHintRegistry routingHintRegistry = (IRoutingHintRegistry)CServiceRegistry.getInstance().getService(IRoutingHintRegistry.class);
        if (routingHintRegistry != null) {
            CNodeId nodeId = routingHintRegistry.getBridgeNode(aClientContext.getTargetAddress().getNodeAddress());
            CRecordOpenDialog.setRoutingHint(aRecord, nodeId);
        }
    }

    @NotNull
    public static CDialogDto convertRecordToDto(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord, @NotNull CTargetAddress aAddress) {
        IRoutingHintRegistry routingHintRegistry;
        String sessionToken = CRecordOpenDialog.getSessionToken(aRecord, null);
        CUtilCheck.checkNotNull((Object)sessionToken, (String)"Session Token missing", (Object[])new Object[0]);
        CTargetAddress clientContextAddress = CRecordOpenDialog.getClientContextAddress(aRecord, null);
        CUtilCheck.checkNotNull((Object)clientContextAddress, (String)"Client Context Address missing", (Object[])new Object[0]);
        IId clientContextId = CRecordOpenDialog.getClientContextId(aRecord, null);
        CUtilCheck.checkNotNull((Object)clientContextId, (String)"Client Context ID missing", (Object[])new Object[0]);
        String platformType = CRecordOpenDialog.getPlatformType(aRecord, null);
        CUtilCheck.checkNotNull((Object)platformType, (String)"Platform Type missing", (Object[])new Object[0]);
        CWidgetId parentWidgetId = CRecordOpenDialog.getParentWidgetId(aRecord, null);
        CUtilCheck.checkNotNull((Object)parentWidgetId, (String)"Parent Widget ID missing", (Object[])new Object[0]);
        CNodeId routingHint = CRecordOpenDialog.getRoutingHint(aRecord, null);
        if (routingHint != null && (routingHintRegistry = (IRoutingHintRegistry)CServiceRegistry.getInstance().getService(IRoutingHintRegistry.class)) != null) {
            routingHintRegistry.add(new CRoutingHint(clientContextAddress.getNodeAddress(), routingHint));
        }
        return new CDialogDto(sessionToken, aAddress, aEnvelope.getSender(), new CClientContextDto(clientContextId, clientContextAddress, platformType), parentWidgetId);
    }
}

