/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table;

import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table.CAbstractCellRenderer;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table.CCell;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table.CTable;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table.CTableModel;
import de.sillysky.nyssr.util.CUtilBoolean;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;

public class CTableCellRendererBoolean
extends CAbstractCellRenderer {
    private static final long serialVersionUID = -8690656968714509310L;

    public CTableCellRendererBoolean(CTable aTable) {
        super(aTable);
    }

    @Override
    public Component getTableCellRendererComponent(@NotNull JTable aTable, Object aValue, boolean aIsSelected, boolean aHasFocus, int aRowIndex, int aColumnIndex) {
        int rowIndex = this.getTable().convertRowIndexToModel(aRowIndex);
        CTableModel model = this.getTable().getMyModel();
        CCell cell = model.getCellOrNull(aColumnIndex, rowIndex);
        JCheckBox cb = new JCheckBox();
        if (aValue instanceof String) {
            boolean b = CUtilBoolean.fromString((String)((String)aValue), (boolean)false);
            cb.setSelected(b);
        } else if (aValue instanceof Boolean) {
            cb.setSelected((Boolean)aValue);
        }
        cb.setHorizontalAlignment(0);
        cb.setBackground(aIsSelected ? UIManager.getColor("Table.selectionBackground") : UIManager.getColor("Table.background"));
        cb.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
        JCheckBox component = cb;
        if (cell != null) {
            this.handleBackground(component, cell, aIsSelected);
            this.handleForeground(component, cell, aIsSelected);
            this.handleBorder(component, cell, aHasFocus);
            this.handleFont(component, cell);
        }
        return component;
    }
}

