/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.client.swing.widget;

import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.CSwingTextComponent;
import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.remoteskin.model.CAttributeHandlerList;
import de.sillysky.nyssr.remoteskin.model.CWidgetSet;
import de.sillysky.nyssr.remoteskin.model.EWidgetTypes;
import de.sillysky.nyssr.remoteskin.model.events.CEventInsertText;
import de.sillysky.nyssr.remoteskin.model.events.CEventReplaceText;
import de.sillysky.nyssr.util.CUtilInteger;
import javax.swing.JTextArea;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CSwingTextArea
extends CSwingTextComponent {
    private static final ILogger LOG = CLoggerFactory.getLogger(CSwingTextArea.class);
    private final JTextArea mComponent = new JTextArea();

    CSwingTextArea(@NotNull CWidgetSet aWidgetSet, @NotNull String aId, @NotNull CJsonObject aAttributes) {
        super(aWidgetSet, aId);
        CAttributeHandlerList list = this.getAttributeHandlerList();
        list.addHandler("autoLineWrap", this::applyAutoLineWrap);
        list.addHandler("heightInCharacters", this::applyHeightInCharacters);
        list.addHandler("insertText", this::applyInsertText);
        list.addHandler("replaceText", this::applyReplaceText);
        list.addHandler("tabSize", this::applyTabSize);
        list.addHandler("widthInCharacters", this::applyWidthInCharacters);
        list.addHandler("wordWrapStyle", this::applyWordWrapStyle);
    }

    private boolean applyAutoLineWrap(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            boolean enabled = (Boolean)aValue;
            this.mComponent.setLineWrap(enabled);
            return true;
        }
        return false;
    }

    private boolean applyHeightInCharacters(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Number) {
            int col = CUtilInteger.fromObject((Object)aValue, (int)10);
            LOG.debug("Set {} to {}", new Object[]{aKey, col});
            this.mComponent.setRows(col);
            return true;
        }
        return false;
    }

    private boolean applyInsertText(@NotNull String aKey, @Nullable Object aValue) {
        CEventInsertText event = CEventInsertText.create((Object)aValue);
        if (event != null) {
            String text = event.getText();
            Boolean append = event.getAppend();
            if (append != null && append.booleanValue()) {
                this.mComponent.append(text);
                return true;
            }
            Integer position = event.getPosition();
            if (position != null) {
                if (position >= 0 && position < this.size()) {
                    this.mComponent.insert(text, position);
                    return true;
                }
                LOG.error("Position out of range: TextLength={}, given position={}", new Object[]{this.size(), position});
            }
        }
        return false;
    }

    private boolean applyReplaceText(@NotNull String aKey, @Nullable Object aValue) {
        CEventReplaceText event = CEventReplaceText.create((Object)aValue);
        if (event != null) {
            String text = event.getText();
            int positionStart = event.getPositionStart();
            int positionEnd = event.getPositionEnd();
            this.mComponent.replaceRange(text, positionStart, positionEnd);
        }
        return false;
    }

    private boolean applyTabSize(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Number) {
            int tabSize = CUtilInteger.fromObject((Object)aValue, (int)4);
            LOG.debug("Set Tab Size to {}", new Object[]{Integer.toString(tabSize)});
            this.mComponent.setTabSize(tabSize);
            return true;
        }
        return false;
    }

    private boolean applyWidthInCharacters(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Number) {
            int col = CUtilInteger.fromObject((Object)aValue, (int)10);
            LOG.debug("Set {} to {}", new Object[]{aKey, col});
            this.mComponent.setColumns(col);
            return true;
        }
        return false;
    }

    private boolean applyWordWrapStyle(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            boolean enabled = (Boolean)aValue;
            this.mComponent.setWrapStyleWord(enabled);
            return true;
        }
        return false;
    }

    private int size() {
        return this.mComponent.getDocument().getLength();
    }

    @NotNull
    public JTextArea getComponent() {
        return this.mComponent;
    }

    @Override
    @NotNull
    public String getWidgetType() {
        return EWidgetTypes.TextArea.name();
    }
}

