/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.client.swing.events;

import de.sillysky.nyssr.remoteskin.model.CWidget;
import de.sillysky.nyssr.remoteskin.model.events.CEventMouseNotification;
import de.sillysky.nyssr.util.swing.CIntegerToStringMap;
import de.sillysky.nyssr.util.swing.key.EKeyModifier;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class CUtilSwingMouseEvent {
    public static final CIntegerToStringMap mButtonMap = new CIntegerToStringMap("Buttons");

    private CUtilSwingMouseEvent() {
    }

    @NotNull
    public static String[] getModList(int aModifiers) {
        ArrayList<String> modString = new ArrayList<String>();
        if ((aModifiers & 0x40) == 64) {
            modString.add("SHIFT");
        }
        if ((aModifiers & 0x200) == 512) {
            modString.add("ALT");
        }
        if ((aModifiers & 0x80) == 128) {
            modString.add("CTRL");
        }
        if ((aModifiers & 0x100) == 256) {
            modString.add("META");
        }
        if ((aModifiers & 0x400) == 1024) {
            modString.add("BUTTON1");
        }
        if ((aModifiers & 0x800) == 2048) {
            modString.add("BUTTON2");
        }
        if ((aModifiers & 0x1000) == 4096) {
            modString.add("BUTTON3");
        }
        return modString.toArray(new String[0]);
    }

    @NotNull
    public static Collection<EKeyModifier> getKeyModifierCollection(int aModifiers) {
        ArrayList<EKeyModifier> modList = new ArrayList<EKeyModifier>();
        if ((aModifiers & 0x40) == 64) {
            modList.add(EKeyModifier.shift);
        }
        if ((aModifiers & 0x200) == 512) {
            modList.add(EKeyModifier.alt);
        }
        if ((aModifiers & 0x80) == 128) {
            modList.add(EKeyModifier.ctrl);
        }
        if ((aModifiers & 0x100) == 256) {
            modList.add(EKeyModifier.meta);
        }
        if ((aModifiers & 0x400) == 1024) {
            modList.add(EKeyModifier.button1);
        }
        if ((aModifiers & 0x800) == 2048) {
            modList.add(EKeyModifier.button2);
        }
        if ((aModifiers & 0x1000) == 4096) {
            modList.add(EKeyModifier.button3);
        }
        return modList;
    }

    public static void sendMouseEvent(@NotNull CWidget aWidget, @NotNull String aKey, @NotNull MouseEvent aMouseEvent) {
        String button = mButtonMap.get(aMouseEvent.getButton());
        int mod = aMouseEvent.getModifiersEx();
        CEventMouseNotification event = new CEventMouseNotification();
        event.setClickCount(aMouseEvent.getClickCount());
        event.setPosition(aMouseEvent.getPoint());
        event.setScreenPosition(aMouseEvent.getLocationOnScreen());
        event.setPopupTrigger(aMouseEvent.isPopupTrigger());
        Collection<EKeyModifier> modList = CUtilSwingMouseEvent.getKeyModifierCollection(mod);
        for (EKeyModifier modifier : modList) {
            event.addKeyModifier(modifier);
        }
        aWidget.enrichMouseEvent(event);
        Object jo = event.toJson();
        aWidget.addNotification(aKey, jo);
        aWidget.sendNotification();
    }

    static {
        mButtonMap.add("NOBUTTON", 0);
        mButtonMap.add("BUTTON1", 1);
        mButtonMap.add("BUTTON2", 2);
        mButtonMap.add("BUTTON3", 3);
    }
}

