/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.model.events.border;

import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonBoolean;
import de.sillysky.nyssr.remoteskin.model.events.CEventColor;
import de.sillysky.nyssr.remoteskin.model.events.IRemoteSkinEvent;
import de.sillysky.nyssr.remoteskin.model.events.border.EBorderType;
import de.sillysky.nyssr.remoteskin.model.events.border.IBorder;
import java.awt.Color;
import javax.swing.BorderFactory;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CEventBevelBorder
implements IBorder,
IRemoteSkinEvent {
    private final boolean mSoft;
    private final boolean mRaised;
    private final Color mInnerHighlightColor;
    private final Color mOuterHighlightColor;
    private final Color mInnerShadowColor;
    private final Color mOuterShadowColor;

    public CEventBevelBorder(boolean aSoft, boolean aRaised, Color aOuterHighlightColor, Color aInnerHighlightColor, Color aOuterShadowColor, Color aInnerShadowColor) {
        this.mSoft = aSoft;
        this.mRaised = aRaised;
        this.mInnerHighlightColor = aInnerHighlightColor;
        this.mOuterHighlightColor = aOuterHighlightColor;
        this.mInnerShadowColor = aInnerShadowColor;
        this.mOuterShadowColor = aOuterShadowColor;
    }

    @Nullable
    public static CEventBevelBorder create(@Nullable Object aValue) {
        if (aValue instanceof CJsonObject) {
            CJsonObject jo = (CJsonObject)aValue;
            Color hi = UIManager.getColor("internalframe.borderlight");
            Color ho = UIManager.getColor("internalframe.borderhighlight");
            Color si = UIManager.getColor("internalframe.borderdarkshadow");
            Color so = UIManager.getColor("internalframe.bordershadow");
            boolean soft = CUtilJsonBoolean.fromJson((CJsonObject)jo, (String)EKeys.soft.name(), (boolean)false);
            boolean raised = CUtilJsonBoolean.fromJson((CJsonObject)jo, (String)EKeys.raised.name(), (boolean)true);
            hi = CEventBevelBorder.parseColor(jo, EKeys.innerhighlight.name(), hi);
            ho = CEventBevelBorder.parseColor(jo, EKeys.outerhighlight.name(), ho);
            si = CEventBevelBorder.parseColor(jo, EKeys.innershadow.name(), si);
            so = CEventBevelBorder.parseColor(jo, EKeys.outershadow.name(), so);
            return new CEventBevelBorder(soft, raised, ho, hi, so, si);
        }
        return null;
    }

    @Nullable
    private static Color parseColor(@NotNull CJsonObject aValue, @NotNull String aKey, @Nullable Color aDefault) {
        Object o = aValue.getValue(aKey);
        CEventColor dc = CEventColor.create(o);
        return dc == null ? aDefault : dc.createColor();
    }

    public boolean isSoft() {
        return this.mSoft;
    }

    public boolean isRaised() {
        return this.mRaised;
    }

    public Color getInnerHighlightColor() {
        return this.mInnerHighlightColor;
    }

    public Color getOuterHighlightColor() {
        return this.mOuterHighlightColor;
    }

    public Color getInnerShadowColor() {
        return this.mInnerShadowColor;
    }

    public Color getOuterShadowColor() {
        return this.mOuterShadowColor;
    }

    @Override
    public Border createBorder() {
        if (this.mSoft) {
            return BorderFactory.createSoftBevelBorder(this.mRaised ? 0 : 1, this.mOuterHighlightColor, this.mInnerHighlightColor, this.mOuterShadowColor, this.mInnerShadowColor);
        }
        return BorderFactory.createBevelBorder(this.mRaised ? 0 : 1, this.mOuterHighlightColor, this.mInnerHighlightColor, this.mOuterShadowColor, this.mInnerShadowColor);
    }

    @Override
    @NotNull
    public Object toJson() {
        CJsonObject jo = new CJsonObject(true);
        jo.put(EKeys.border_type.name(), (Object)this.getType().name());
        jo.put(EKeys.soft.name(), (Object)this.mSoft);
        jo.put(EKeys.raised.name(), (Object)this.mRaised);
        jo.put(EKeys.outerhighlight.name(), new CEventColor(this.mOuterHighlightColor).toJson());
        jo.put(EKeys.innerhighlight.name(), new CEventColor(this.mInnerHighlightColor).toJson());
        jo.put(EKeys.outershadow.name(), new CEventColor(this.mOuterShadowColor).toJson());
        jo.put(EKeys.innershadow.name(), new CEventColor(this.mInnerShadowColor).toJson());
        return jo;
    }

    @Override
    public EBorderType getType() {
        return EBorderType.bevel;
    }

    private static enum EKeys {
        border_type,
        soft,
        raised,
        innerhighlight,
        outerhighlight,
        innershadow,
        outershadow;

    }
}

