/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.model.events;

import de.sillysky.nyssr.id.widget.CWidgetId;
import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonString;
import de.sillysky.nyssr.remoteskin.model.events.IRemoteSkinEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CEventWidgetId
implements IRemoteSkinEvent {
    public static final String WIDGET_SET_NAME = "widgetSetName";
    public static final String WIDGET_SET_INSTANCE = "widgetSetInstance";
    public static final String WIDGET_NAME = "widgetName";
    private final CWidgetId mWidgetId;

    public CEventWidgetId(@NotNull CWidgetId aWidgetId) {
        this.mWidgetId = aWidgetId;
    }

    public CEventWidgetId(@NotNull String aWidgetName, @NotNull String aWidgetSetName, @NotNull String aInstance) {
        this.mWidgetId = CWidgetId.create((String)aWidgetName, (String)aWidgetSetName, (String)aInstance);
    }

    @Nullable
    public static CEventWidgetId create(@Nullable Object aValue) {
        CWidgetId widgetId;
        if (aValue instanceof CJsonObject) {
            CJsonObject jo = (CJsonObject)aValue;
            String wSetName = CUtilJsonString.fromJson((CJsonObject)jo, (String)WIDGET_SET_NAME, null);
            String inst = CUtilJsonString.fromJson((CJsonObject)jo, (String)WIDGET_SET_INSTANCE, null);
            String name = CUtilJsonString.fromJson((CJsonObject)jo, (String)WIDGET_NAME, null);
            if (wSetName != null && name != null) {
                CWidgetId widgetId2 = CWidgetId.create((String)name, (String)wSetName, (String)inst);
                return new CEventWidgetId(widgetId2);
            }
        } else if (aValue instanceof String && (widgetId = CWidgetId.create((String)((String)aValue))) != null) {
            return new CEventWidgetId(widgetId);
        }
        return null;
    }

    @NotNull
    public CWidgetId getWidgetId() {
        return this.mWidgetId;
    }

    @Override
    @NotNull
    public Object toJson() {
        return this.mWidgetId.valueToString();
    }
}

