/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.model.events;

import de.sillysky.nyssr.json.CJsonArray;
import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.remoteskin.model.events.CEventTableColumn;
import de.sillysky.nyssr.remoteskin.model.events.IRemoteSkinEvent;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CEventTableColumns
implements IRemoteSkinEvent {
    public static final String COLUMNS = "columns";
    private final List<CEventTableColumn> mColumns;

    public CEventTableColumns(@NotNull List<CEventTableColumn> aColumns) {
        this.mColumns = aColumns;
    }

    @Nullable
    public static CEventTableColumns create(@Nullable Object aValue) {
        if (aValue instanceof CJsonObject) {
            CJsonObject jo = (CJsonObject)aValue;
            Object oo = jo.getValue(COLUMNS);
            if (oo instanceof CJsonArray) {
                List<CEventTableColumn> columns = CEventTableColumns.readColumns((CJsonArray)oo);
                return new CEventTableColumns(columns);
            }
        } else if (aValue instanceof CJsonArray) {
            List<CEventTableColumn> columns = CEventTableColumns.readColumns((CJsonArray)aValue);
            return new CEventTableColumns(columns);
        }
        return null;
    }

    @NotNull
    private static List<CEventTableColumn> readColumns(@NotNull CJsonArray aJsonArray) {
        ArrayList<CEventTableColumn> columns = new ArrayList<CEventTableColumn>();
        for (Object o : aJsonArray.getChildren()) {
            CEventTableColumn column = CEventTableColumn.create(o);
            if (column == null) continue;
            columns.add(column);
        }
        return columns;
    }

    public List<CEventTableColumn> getColumns() {
        return this.mColumns;
    }

    @Override
    @NotNull
    public Object toJson() {
        CJsonObject jo = new CJsonObject(true);
        CJsonArray arr = new CJsonArray();
        for (CEventTableColumn col : this.mColumns) {
            arr.add(col.toJson());
        }
        jo.put(COLUMNS, (Object)arr);
        return jo;
    }
}

