/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.app.instance.registry;

import de.sillysky.nyssr.impl.app.IApplicationPresetRegistry;
import de.sillysky.nyssr.impl.app.instance.registry.CAppInstanceRegistry;
import de.sillysky.nyssr.impl.app.instance.registry.IDependencies;
import de.sillysky.nyssr.kernel.configuration.IKernelConfiguration;
import de.sillysky.nyssr.namedb.INameDb;
import de.sillysky.nyssr.namespace.IRecordHelper;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.service.IServiceStarter;
import org.jetbrains.annotations.NotNull;

public final class CPackageAppInstanceRegistry
implements IServiceStarter,
IDependencies {
    private IService mService;
    private IApplicationPresetRegistry mApplicationPresetRegistry;
    private IKernelConfiguration mKernelConfiguration;
    private IRecordHelper mRecordHelper;
    private INameDb mNameDb;

    public void getDependencies(@NotNull IServiceDependencyList aDependencyList) {
        aDependencyList.add(IKernelConfiguration.class);
        aDependencyList.add(IApplicationPresetRegistry.class);
        aDependencyList.add(IRecordHelper.class);
        aDependencyList.add(INameDb.class);
    }

    public void start(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        if (this.mService == null) {
            this.mKernelConfiguration = (IKernelConfiguration)aServiceRegistry.getServiceOrThrow(IKernelConfiguration.class);
            this.mApplicationPresetRegistry = (IApplicationPresetRegistry)aServiceRegistry.getServiceOrThrow(IApplicationPresetRegistry.class);
            this.mRecordHelper = (IRecordHelper)aServiceRegistry.getServiceOrThrow(IRecordHelper.class);
            this.mNameDb = (INameDb)aServiceRegistry.getServiceOrThrow(INameDb.class);
            this.mService = new CAppInstanceRegistry(this);
            this.mService.activate(aServiceRegistry);
        }
    }

    public void stop(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        if (this.mService != null) {
            this.mService.deactivate(aServiceRegistry);
            this.mService = null;
        }
    }

    @Override
    public IApplicationPresetRegistry getApplicationPresetRegistry() {
        return this.mApplicationPresetRegistry;
    }

    @Override
    public IKernelConfiguration getKernelConfiguration() {
        return this.mKernelConfiguration;
    }

    @Override
    public INameDb getNameDb() {
        return this.mNameDb;
    }

    @Override
    public IRecordHelper getRecordHelper() {
        return this.mRecordHelper;
    }
}

