/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util;

import de.sillysky.nyssr.util.CPositiveInteger;
import de.sillysky.nyssr.util.CUtilRandom;
import de.sillysky.nyssr.util.CUtilString;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CUtilStringArray {
    public static final String[] EMPTY = new String[0];
    private static final int ITEM_STRING_LENGTH = 30;
    private static final int MAX_LEN = 7;

    private CUtilStringArray() {
    }

    @NotNull
    public static String[] copy(String @Nullable [] aValue) {
        if (aValue == null) {
            return null;
        }
        return Arrays.copyOf(aValue, aValue.length);
    }

    @NotNull
    public static String[] fromList(@Nullable List<?> aValue) {
        if (aValue == null || aValue.isEmpty()) {
            return EMPTY;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (Object element : aValue) {
            if (element == null) continue;
            if (element instanceof String) {
                String e = (String)element;
                list.add(e);
                continue;
            }
            if (!(element instanceof String[])) continue;
            String[] ee = (String[])element;
            Collections.addAll(list, ee);
        }
        String[] arr = new String[list.size()];
        int pos = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String element;
            arr[pos] = element = (String)iterator.next();
            ++pos;
        }
        return arr;
    }

    public static @NotNull String @Nullable [] fromStream(@NotNull DataInput aStream) throws IOException {
        int len = CPositiveInteger.fromStream(aStream);
        if (len == 0) {
            return null;
        }
        String[] array = new String[len - 1];
        for (int i = 0; i < len - 1; ++i) {
            array[i] = CUtilString.fromStream(aStream);
        }
        return array;
    }

    @NotNull
    public static String[] fromString(@Nullable String aStr) {
        return CUtilStringArray.fromString(aStr, '|');
    }

    @NotNull
    public static String[] fromString(@Nullable String aStr, char aDelimiter) {
        String[] result;
        if (aStr == null || aStr.isEmpty()) {
            result = new String[]{};
        } else {
            ArrayList<String> list = new ArrayList<String>();
            StringBuilder sb = new StringBuilder(200);
            boolean escape = false;
            for (int i = 0; i < aStr.length(); ++i) {
                char c = aStr.charAt(i);
                if (escape) {
                    if (c == aDelimiter) {
                        sb.append(aDelimiter);
                    } else {
                        sb.append('\\');
                        sb.append(c);
                    }
                    escape = false;
                    continue;
                }
                if (c == '\\') {
                    escape = true;
                    continue;
                }
                if (c == aDelimiter) {
                    list.add(sb.toString());
                    sb.setLength(0);
                    continue;
                }
                sb.append(c);
            }
            if (sb.length() > 0) {
                list.add(sb.toString());
            }
            result = new String[list.size()];
            if (!list.isEmpty()) {
                result = list.toArray(result);
            }
        }
        return result;
    }

    @NotNull
    public static @NotNull String @NotNull [] split(@Nullable String aSource, @NotNull String aDelimiter) {
        if (CUtilString.isEmpty(aSource)) {
            return new String[0];
        }
        return (String[])Arrays.stream(aSource.trim().split(aDelimiter)).map(String::trim).toArray(String[]::new);
    }

    @NotNull
    public static @NotNull String @NotNull [] random(int aLength, boolean aWithNullValues) {
        String[] array = new String[aLength];
        for (int i = 0; i < aLength; ++i) {
            boolean b = CUtilRandom.getRandom().nextBoolean();
            if (!b && aWithNullValues) continue;
            array[i] = CUtilString.random(CUtilRandom.getRandom().nextInt(7));
        }
        return array;
    }

    public static boolean isEqual(@Nullable String[] aValue1, @Nullable String[] aValue2) {
        return Arrays.equals(aValue1, aValue2);
    }

    @NotNull
    public static String toStringWithColon(@NotNull String[] aValue) {
        return CUtilStringArray.toString(aValue, 0, aValue.length, ',', 0, '\u0000');
    }

    @NotNull
    public static String toStringWithPipe(String[] aValue) {
        return CUtilStringArray.toString(aValue, 0, aValue.length, '|', 0, '\u0000');
    }

    @NotNull
    public static String toString(@Nullable String[] aValue, int aPos, int aLength, char aDelimiter, int aMaxLen, char aEscape) {
        String result;
        if (aValue == null || aValue.length == 0) {
            result = "";
        } else {
            int maxLen = aMaxLen > 0 ? aMaxLen + 30 : 30 * aValue.length;
            StringBuilder sb = new StringBuilder(maxLen);
            boolean first = true;
            for (int pos = aPos; pos < aPos + aLength; ++pos) {
                if (first) {
                    first = false;
                } else {
                    sb.append(aDelimiter);
                }
                String s = CUtilString.escapeSlot(aValue[pos], aDelimiter);
                if (aEscape != '\u0000') {
                    sb.append(aEscape);
                }
                sb.append(s);
                if (aEscape != '\u0000') {
                    sb.append(aEscape);
                }
                if (aMaxLen > 0 && sb.length() >= aMaxLen) break;
            }
            if (aMaxLen > 0 && sb.length() > aMaxLen) {
                sb.setLength(aMaxLen);
            }
            result = sb.toString();
        }
        return result;
    }

    public static void toList(@Nullable String[] aValue, @NotNull List<String> aList) {
        if (aValue != null && aValue.length != 0) {
            Collections.addAll(aList, aValue);
        }
    }

    public static void toStream(@NotNull DataOutput aStream, @Nullable String[] aValue) throws IOException {
        if (aValue == null) {
            CPositiveInteger.toStream(aStream, 0);
        } else {
            CPositiveInteger.toStream(aStream, aValue.length + 1);
            for (String element : aValue) {
                CUtilString.toStream(aStream, element);
            }
        }
    }

    @NotNull
    public static String toString(@Nullable Iterable<String> aStrings) {
        return CUtilStringArray.toString(aStrings, '|');
    }

    @NotNull
    public static String toString(@Nullable Iterable<String> aStrings, char aDelimiter) {
        if (aStrings == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(2000);
        boolean first = true;
        for (String sss : aStrings) {
            if (first) {
                first = false;
            } else {
                sb.append(aDelimiter);
            }
            String s = CUtilString.escapeSlot(sss, aDelimiter);
            sb.append(s);
        }
        String result = sb.toString();
        return result;
    }

    @NotNull
    public static String toString(@Nullable String[] aStr, char aDelimiter) {
        return CUtilStringArray.toString(aStr, 0, aStr.length, aDelimiter, 0, '0');
    }

    @NotNull
    public static List<String> fromObject(@Nullable Object aValue) {
        ArrayList<String> list = new ArrayList<String>();
        if (aValue instanceof String) {
            @NotNull String[] arr = CUtilStringArray.fromString((String)aValue, ',');
            list.addAll(Arrays.asList(arr));
        }
        return list;
    }

    @NotNull
    public static List<String> fromArray(@Nullable String[] aArray) {
        ArrayList<String> list = new ArrayList<String>();
        if (aArray != null) {
            for (String s : aArray) {
                list.add(s == null ? "" : s);
            }
        }
        return list;
    }

    public static boolean contains(@Nullable String[] aArray, @NotNull String aString) {
        if (aArray != null) {
            for (String s : aArray) {
                if (!CUtilString.equals(s, aString)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isEmpty(@Nullable String[] aList) {
        return aList == null || aList.length == 0;
    }
}

