/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.timer;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.EIdType;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.common.CWellKnownNID;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.impl.timer.CTimerEntry;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.IMessageSender;
import de.sillysky.nyssr.namedb.INameDb;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.thread.IThreadFactory;
import de.sillysky.nyssr.timer.ITimerManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CTimerManager
implements Runnable,
ITimerManager,
IService {
    private static final ILogger LOG = CLoggerFactory.getLogger(CTimerManager.class);
    private static final long TIMEOUT = 48L;
    private static final int WARNING_AFTER = 20;
    private static long mLastSystemTick = System.currentTimeMillis();
    private final List<CTimerEntry> mTimers = new ArrayList<CTimerEntry>();
    private IMessageSender mSender;
    private ScheduledExecutorService mScheduler;
    private CTargetAddress mSenderAddress;
    private int mPeak;

    CTimerManager() {
    }

    static long tick() {
        return mLastSystemTick;
    }

    static void addDependencies(@NotNull IServiceDependencyList aDependencyList) {
        aDependencyList.add(INameDb.class);
        aDependencyList.add(IMessageSender.class);
        aDependencyList.add(IThreadFactory.class);
    }

    @Override
    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws CException {
        this.mSender = aServiceRegistry.getService(IMessageSender.class);
        IThreadFactory threadFactory = aServiceRegistry.getServiceOrThrow(IThreadFactory.class);
        LOG.info("--------- TimerManager 0");
        this.mPeak = 0;
        this.mScheduler = threadFactory.getScheduledThreadPool();
        if (this.mScheduler == null) {
            throw new CException(2301).append("Scheduler not found.");
        }
        this.mScheduler.scheduleAtFixedRate(this, 0L, 48L, TimeUnit.MILLISECONDS);
        this.mSenderAddress = new CTargetAddress(CIdFactory.fromObject(EIdType.STRING, "TimerManager"), CWellKnownNID.SYSTEM, this.mSender.getNodeAddress());
        INameDb nameDb = aServiceRegistry.getServiceOrThrow(INameDb.class);
        nameDb.getTargetAddressDatabase().putName(this.mSenderAddress, "TimerManager");
        aServiceRegistry.registerService(ITimerManager.class, this);
        LOG.info("--------- TimerManager 1");
    }

    @Override
    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        aServiceRegistry.deregisterService(this);
        LOG.info("--------- TimerManager 0");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dismiss() {
        this.mScheduler.shutdown();
        List<CTimerEntry> list = this.mTimers;
        synchronized (list) {
            this.mTimers.clear();
        }
    }

    IMessageSender getSender() {
        return this.mSender;
    }

    CTargetAddress getSenderAddress() {
        return this.mSenderAddress;
    }

    @Override
    public long getSystemTick() {
        return mLastSystemTick;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getTimerHandle(@NotNull IId aMID, @NotNull CTargetAddress aReceiver) {
        List<CTimerEntry> list = this.mTimers;
        synchronized (list) {
            for (CTimerEntry timer : this.mTimers) {
                if (!timer.matchMTN(aMID, aReceiver)) continue;
                return timer.getHandle();
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTimerActive(long aHandle) {
        if (aHandle > 0L) {
            List<CTimerEntry> list = this.mTimers;
            synchronized (list) {
                for (CTimerEntry timer : this.mTimers) {
                    if (timer.getHandle() != aHandle) continue;
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyNamespaceDeregistered(@NotNull IId aNID) {
        List<CTimerEntry> list = this.mTimers;
        synchronized (list) {
            Iterator<CTimerEntry> it = this.mTimers.iterator();
            while (it.hasNext()) {
                CTimerEntry timer = it.next();
                if (!timer.match(null, aNID)) continue;
                timer.dismiss();
                it.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyTargetDeregistered(@NotNull CTargetAddress aAddress) {
        List<CTimerEntry> list = this.mTimers;
        synchronized (list) {
            Iterator<CTimerEntry> it = this.mTimers.iterator();
            while (it.hasNext()) {
                CTimerEntry timer = it.next();
                if (!timer.match(aAddress.getTID(), aAddress.getNID())) continue;
                timer.dismiss();
                it.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean resetTimer(long aHandle) {
        List<CTimerEntry> list = this.mTimers;
        synchronized (list) {
            for (CTimerEntry timer : this.mTimers) {
                if (timer.getHandle() != aHandle) continue;
                timer.reset();
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        mLastSystemTick = System.currentTimeMillis();
        List<CTimerEntry> list = this.mTimers;
        synchronized (list) {
            Iterator<CTimerEntry> it = this.mTimers.iterator();
            while (it.hasNext()) {
                CTimerEntry timer = it.next();
                boolean result = false;
                try {
                    result = timer.trigger();
                }
                catch (CException e) {
                    e.printStackTrace();
                }
                if (!result) continue;
                timer.dismiss();
                it.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long createAndStartTimer(@NotNull IId aMID, @NotNull CTargetAddress aAddress, long aTimeout, boolean aRepeat, @Nullable CRecord aRecord) {
        int size;
        if (!CIdFactory.isValid(aMID)) {
            LOG.error("startTimer with invalid arguments [MID={}]", aMID);
            return 0L;
        }
        if (aAddress == null) {
            LOG.error("startTimer with invalid arguments [Address=null]");
            return 0L;
        }
        if (!aAddress.getTID().isValid()) {
            LOG.error("startTimer with invalid arguments [TID={}]", aAddress.getTID());
            return 0L;
        }
        if (!aAddress.getNID().isValid()) {
            LOG.error("startTimer with invalid arguments [NID={}]", aAddress.getNID());
            return 0L;
        }
        if (aTimeout <= 0L) {
            LOG.error("startTimer with invalid timeout [timeout={}]", aTimeout);
            return 0L;
        }
        CTimerEntry timer = new CTimerEntry(this, aAddress, aMID, aTimeout, aRepeat, aRecord);
        List<CTimerEntry> list = this.mTimers;
        synchronized (list) {
            this.mTimers.add(timer);
            size = this.mTimers.size();
        }
        if (size > this.mPeak) {
            ++this.mPeak;
            if (this.mPeak > 20) {
                LOG.warn("> {} Timer allocated!", this.mPeak);
            }
        }
        return timer.getHandle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean dismissTimer(long aHandle) {
        List<CTimerEntry> list = this.mTimers;
        synchronized (list) {
            Iterator<CTimerEntry> it = this.mTimers.iterator();
            while (it.hasNext()) {
                CTimerEntry timer = it.next();
                if (timer.getHandle() != aHandle) continue;
                timer.dismiss();
                it.remove();
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Contract(pure=true)
    @NotNull
    public String toString() {
        int size;
        List<CTimerEntry> list = this.mTimers;
        synchronized (list) {
            size = this.mTimers.size();
        }
        return "TimerServer: " + size + " used, Peak is " + this.mPeak;
    }
}

