/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.slot;

import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISingleSlotTypeFactory;
import de.sillysky.nyssr.slot.ISlot;
import de.sillysky.nyssr.util.CUtilFloat;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CSlotFloat
implements ISlot,
ISingleSlotTypeFactory {
    @NotNull
    private final Float mValue;

    CSlotFloat() {
        this.mValue = Float.valueOf(0.0f);
    }

    private CSlotFloat(float aValue) {
        this.mValue = Float.valueOf(aValue);
    }

    private CSlotFloat(@Nullable Float aValue) {
        this.mValue = aValue == null ? Float.valueOf(0.0f) : aValue;
    }

    @NotNull
    private static CSlotFloat fromObject(@Nullable Object aValue) {
        if (aValue instanceof Float) {
            return new CSlotFloat((Float)aValue);
        }
        if (aValue instanceof String) {
            return CSlotFloat.fromString((String)aValue);
        }
        if (aValue instanceof List) {
            return CSlotFloat.fromList((List)aValue);
        }
        return new CSlotFloat();
    }

    @NotNull
    private static CSlotFloat fromList(@NotNull List<?> aValue) {
        CSlotFloat result;
        if (aValue.isEmpty()) {
            result = new CSlotFloat();
        } else {
            Object object = aValue.get(0);
            result = CSlotFloat.fromObject(object);
        }
        return result;
    }

    @NotNull
    private static CSlotFloat fromStream(@NotNull DataInput aStream) throws IOException {
        float value = aStream.readFloat();
        return new CSlotFloat(value);
    }

    @NotNull
    private static CSlotFloat fromString(@NotNull String aValue) {
        float value = CUtilFloat.fromString(aValue);
        return new CSlotFloat(value);
    }

    @Override
    @Nullable
    public ISlot fromObject(@NotNull CSlotType aType, @Nullable Object aValue) {
        if (this.getType().equals(aType)) {
            return CSlotFloat.fromObject(aValue);
        }
        return null;
    }

    @Override
    @NotNull
    public ISlot fromJson(@Nullable Object aValue, @NotNull Map<Integer, byte[]> aByteArrayStore) {
        float value = CUtilFloat.fromObject(aValue);
        return new CSlotFloat(value);
    }

    @Override
    public boolean equals(@Nullable Object aObj) {
        if (this == aObj) {
            return true;
        }
        if (aObj == null) {
            return false;
        }
        if (this.getClass() != aObj.getClass()) {
            return false;
        }
        CSlotFloat other = (CSlotFloat)aObj;
        return Float.floatToIntBits(this.mValue.floatValue()) == Float.floatToIntBits(other.mValue.floatValue());
    }

    @Override
    @NotNull
    public Class<?> getClassOfProducedObject() {
        return Float.class;
    }

    @Override
    @NotNull
    public ISlot copy() {
        return this;
    }

    @Override
    @NotNull
    public CSlotType getType() {
        return CCommonSlotType.FLOAT;
    }

    @Override
    @NotNull
    public Object getValue() {
        return this.mValue;
    }

    @Override
    public int hashCode() {
        return this.mValue.hashCode();
    }

    @Override
    public boolean isContentEqualTo(@Nullable Object aValue) {
        return this.mValue.equals(aValue);
    }

    @Override
    @Nullable
    public ISlot readSlot(@NotNull DataInput aStream, @NotNull CSlotType aType) throws IOException {
        if (this.getType().equals(aType)) {
            return CSlotFloat.fromStream(aStream);
        }
        return null;
    }

    @Override
    public void toStream(@NotNull DataOutput aStream) throws IOException {
        aStream.writeFloat(this.mValue.floatValue());
    }

    @NotNull
    public String toString() {
        return Float.toString(this.mValue.floatValue());
    }

    @Override
    @NotNull
    public String valueToString() {
        return Float.toString(this.mValue.floatValue());
    }

    @Override
    @NotNull
    public Object toJson(@NotNull Map<Integer, byte[]> aBinaries) {
        return this.mValue;
    }
}

