/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.shutdown;

import de.sillysky.nyssr.cli.ICommandLineInterface;
import de.sillysky.nyssr.impl.shutdown.CShutDownTarget;
import de.sillysky.nyssr.impl.shutdown.IDependencies;
import de.sillysky.nyssr.namespace.INamespaceRegistry;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.service.IServiceStarter;
import org.jetbrains.annotations.NotNull;

public class CPackageImplShutDown
implements IServiceStarter,
IDependencies {
    private IService mService = null;
    private INamespaceRegistry mNamespaceRegistry;

    @Override
    public void getDependencies(@NotNull IServiceDependencyList aDependencyList) {
        aDependencyList.add(INamespaceRegistry.class);
        aDependencyList.add(ICommandLineInterface.class);
    }

    @Override
    public void start(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        if (this.mService == null) {
            this.mNamespaceRegistry = aServiceRegistry.getServiceOrThrow(INamespaceRegistry.class);
            this.mService = new CShutDownTarget(this);
            this.mService.activate(aServiceRegistry);
        }
    }

    @Override
    public void stop(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        if (this.mService != null) {
            this.mService.deactivate(aServiceRegistry);
            this.mService = null;
        }
    }

    @Override
    public INamespaceRegistry getNamespaceRegistry() {
        return this.mNamespaceRegistry;
    }
}

