/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.plugin.target;

import de.sillysky.nyssr.impl.plugin.target.CTargetForPluginManager;
import de.sillysky.nyssr.impl.plugin.target.IDependencies;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.plugin.IPlugInManager;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.service.IServiceStarter;
import org.jetbrains.annotations.NotNull;

public final class CPackageImplPluginTarget
implements IServiceStarter,
IDependencies {
    private static final String FILTER = "nid=SYSTEM";
    private IService mService;
    private IPlugInManager mPlugInManager;
    private INamespace mSystemNamespace;

    @Override
    public void getDependencies(@NotNull IServiceDependencyList aDependencyList) {
        aDependencyList.add(IPlugInManager.class);
        aDependencyList.add(INamespace.class, FILTER);
    }

    @Override
    public void start(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        if (this.mService == null) {
            this.mPlugInManager = aServiceRegistry.getServiceOrThrow(IPlugInManager.class);
            this.mSystemNamespace = aServiceRegistry.getServiceOrThrow(INamespace.class, FILTER);
            this.mService = new CTargetForPluginManager(this);
            this.mService.activate(aServiceRegistry);
        }
    }

    @Override
    public void stop(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        if (this.mService != null) {
            this.mService.deactivate(aServiceRegistry);
            this.mService = null;
        }
    }

    @Override
    @NotNull
    public IPlugInManager getPlugInManager() {
        return this.mPlugInManager;
    }

    @Override
    @NotNull
    public INamespace getSystemNamespace() {
        return this.mSystemNamespace;
    }
}

