/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.namespace.monitor.target;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.common.CWellKnownNID;
import de.sillysky.nyssr.id.common.CWellKnownTID;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.namespace.IRecordHelper;
import de.sillysky.nyssr.namespace.monitor.INamespaceMonitor;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.records.CRecordNamespaceMonitorAddFilter;
import de.sillysky.nyssr.records.CRecordNamespaceMonitorRemoveFilter;
import de.sillysky.nyssr.records.CRecordNamespaceMonitorRemoveObserver;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.registry.ITargetRegistry;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import org.jetbrains.annotations.NotNull;

class CTargetForNamespaceMonitor
extends CTarget
implements IService {
    private static final String FILTER = "nid=" + CWellKnownNID.SYSTEM;
    private IRecordHelper mHelper;
    private INamespaceMonitor mNamespaceMonitor;

    CTargetForNamespaceMonitor() {
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordNamespaceMonitorAddFilter.ID, this::asyncAddFilter);
        this.addMessageHandler(CRecordNamespaceMonitorRemoveFilter.ID, this::asyncRemoveFilter);
        this.addMessageHandler(CRecordNamespaceMonitorRemoveObserver.ID, this::asyncRemoveObserver);
    }

    public static void getDependencies(IServiceDependencyList aDependencyList) {
        aDependencyList.add(IRecordHelper.class);
        aDependencyList.add(INamespaceMonitor.class);
        aDependencyList.add(ITargetRegistry.class, FILTER);
    }

    @Override
    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        this.mHelper = aServiceRegistry.getService(IRecordHelper.class);
        this.mNamespaceMonitor = aServiceRegistry.getService(INamespaceMonitor.class);
        ITargetRegistry tr = aServiceRegistry.getService(ITargetRegistry.class, FILTER);
        assert (tr != null);
        tr.registerTarget(this, CWellKnownTID.NAMESPACE_MONITOR);
    }

    private boolean asyncAddFilter(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        IId[] filters;
        CTargetAddress observer = CRecordNamespaceMonitorAddFilter.getObserver(aRecord, aEnvelope.getSender());
        CUtilCheck.checkNotNull(observer, "Missing observer", new Object[0]);
        IId filter = CRecordNamespaceMonitorAddFilter.getFilter(aRecord, null);
        if (filter != null) {
            this.mNamespaceMonitor.addFilter(observer, filter);
        }
        if ((filters = CRecordNamespaceMonitorAddFilter.getFilterList(aRecord, null)) != null) {
            for (IId f : filters) {
                this.mNamespaceMonitor.addFilter(observer, f);
            }
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncRemoveFilter(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        IId[] filters;
        CTargetAddress observer = CRecordNamespaceMonitorRemoveFilter.getObserver(aRecord, aEnvelope.getSender());
        CUtilCheck.checkNotNull(observer, "Missing observer", new Object[0]);
        IId filter = CRecordNamespaceMonitorRemoveFilter.getFilter(aRecord, null);
        if (filter != null) {
            this.mNamespaceMonitor.removeFilter(observer, filter);
        }
        if ((filters = CRecordNamespaceMonitorRemoveFilter.getFilterList(aRecord, null)) != null) {
            for (IId f : filters) {
                this.mNamespaceMonitor.removeFilter(observer, f);
            }
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncRemoveObserver(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        CTargetAddress observer = CRecordNamespaceMonitorRemoveFilter.getObserver(aRecord, aEnvelope.getSender());
        CUtilCheck.checkNotNull(observer, "Missing observer", new Object[0]);
        this.mNamespaceMonitor.removeObserver(observer);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        this.mHelper.addObserver(CRecordNamespaceMonitorAddFilter.class, this, false);
        this.mHelper.addObserver(CRecordNamespaceMonitorRemoveFilter.class, this, false);
        this.mHelper.addObserver(CRecordNamespaceMonitorRemoveObserver.class, this, false);
        aEnvelope.setResultSuccess();
        return true;
    }

    @Override
    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        this.deregisterTarget();
    }
}

