/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.dialog.preset.newpreset;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.app.CApplicationDescription;
import de.sillysky.nyssr.id.widget.CWidgetId;
import de.sillysky.nyssr.impl.dialog.preset.CPresetModel;
import de.sillysky.nyssr.impl.dialog.preset.IDialogPresetDependencies;
import de.sillysky.nyssr.impl.dialog.preset.newpreset.CNewPresetTarget;
import de.sillysky.nyssr.remoteskin.server.context.IRemoteSkinServerContext;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CNewPresetModel {
    private final CNewPresetTarget mTarget;
    private final CPresetModel mParentModel;
    private final CTargetAddress mDialogOwner;
    private final CWidgetId mParent;
    private final Collection<String> mExistingPresetNames;
    private final Map<UUID, CApplicationDescription> mApplications = new HashMap<UUID, CApplicationDescription>();
    private String mMessage = "";
    private String mNewPresetName;
    private UUID mAppIdChosen;
    private boolean mIsButtonOkayEnabled;

    CNewPresetModel(@NotNull CNewPresetTarget aTarget, @NotNull CPresetModel aParentModel, @NotNull CTargetAddress aDialogOwner, @NotNull CWidgetId aParent, @NotNull Collection<String> aExistingPresetNames) {
        this.mTarget = aTarget;
        this.mParentModel = aParentModel;
        this.mDialogOwner = aDialogOwner;
        this.mParent = aParent;
        this.mExistingPresetNames = aExistingPresetNames;
    }

    CPresetModel getParentModel() {
        return this.mParentModel;
    }

    CNewPresetTarget getTarget() {
        return this.mTarget;
    }

    IDialogPresetDependencies getDependencies() {
        return this.mParentModel.getDependencies();
    }

    CTargetAddress getDialogOwner() {
        return this.mDialogOwner;
    }

    CWidgetId getParent() {
        return this.mParent;
    }

    CNodeAddress getNodeAddressOfAppStore() {
        return this.mParentModel.getNodeAddressOfAppStore();
    }

    Collection<String> getExistingPresetNames() {
        return this.mExistingPresetNames;
    }

    boolean existPreset(@NotNull String aPresetName) {
        return this.mExistingPresetNames.contains(aPresetName);
    }

    @NotNull
    String getMessage() {
        return this.mMessage;
    }

    void setMessage(@NotNull String aMessage) {
        this.mMessage = aMessage;
    }

    void clearApplications() {
        this.mApplications.clear();
    }

    void addApplication(@NotNull CApplicationDescription aApp) {
        this.mApplications.put(aApp.getAppId(), aApp);
    }

    @NotNull
    Collection<CApplicationDescription> getApplications() {
        return this.mApplications.values();
    }

    public CApplicationDescription getApplicationById(@NotNull UUID aAppId) {
        return this.mApplications.get(aAppId);
    }

    public String getNewPresetName() {
        return this.mNewPresetName;
    }

    public void setNewPresetName(String aNewPresetName) {
        this.mNewPresetName = aNewPresetName;
    }

    public boolean isButtonOkayEnabled() {
        return this.mIsButtonOkayEnabled;
    }

    public void setButtonOkayEnabled(boolean aButtonOkayEnabled) {
        this.mIsButtonOkayEnabled = aButtonOkayEnabled;
    }

    @Nullable
    public UUID getAppIdChosen() {
        return this.mAppIdChosen;
    }

    public void setAppIdChosen(@NotNull UUID aAppIdChosen) {
        this.mAppIdChosen = aAppIdChosen;
    }

    public IRemoteSkinServerContext getServerContext() {
        return this.mParentModel.getServerContext();
    }
}

