/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table;

import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table.CRow;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table.CTableModel;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table.CVisibleIds;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CRowModel {
    private static final ILogger LOG = CLoggerFactory.getLogger(CRowModel.class);
    private final CTableModel mTableModel;
    private final Map<String, CRow> mRows = new HashMap<String, CRow>();
    private final CVisibleIds mRowIndex = new CVisibleIds();

    CRowModel(@NotNull CTableModel aTableModel) {
        this.mTableModel = aTableModel;
    }

    CTableModel getTableModel() {
        return this.mTableModel;
    }

    @NotNull
    CRow getOrAddRow(@NotNull String aRowId) {
        CRow row = this.mRows.get(aRowId);
        if (row == null) {
            row = this.addRow(aRowId);
        }
        return row;
    }

    @NotNull
    CRow addRow(@NotNull String aRowId) {
        CRow row = new CRow(this, aRowId);
        this.mRows.put(aRowId, row);
        this.mRowIndex.addId(aRowId);
        return row;
    }

    @Nullable
    CRow getRowByIndex(int aIndex) {
        String id = this.mRowIndex.getByIndex(aIndex);
        if (id != null) {
            return this.mRows.get(id);
        }
        LOG.error("Table row index out of range: row={}({})", new Object[]{aIndex, this.mRowIndex.size()});
        return null;
    }

    @Nullable
    CRow get(String aId) {
        CRow row = this.mRows.get(aId);
        if (row == null) {
            LOG.error("Table row id not found: {}", new Object[]{aId});
        }
        return row;
    }

    int size() {
        return this.mRowIndex.size();
    }

    void clear() {
        this.mRowIndex.clear();
        this.mRows.clear();
    }

    int getRowIndex(@NotNull String aRowId) {
        return this.mRowIndex.getIndex(aRowId);
    }
}

