/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.client.swing.widget.spinner;

import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.CSwingSlider;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.spinner.CSwingSpinner;
import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonStringList;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.remoteskin.model.CAttributeHandlerList;
import de.sillysky.nyssr.remoteskin.model.CWidgetSet;
import de.sillysky.nyssr.remoteskin.model.EWidgetTypes;
import de.sillysky.nyssr.util.CUtilString;
import java.util.List;
import javax.swing.SpinnerListModel;
import javax.swing.event.ChangeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CSwingListSpinner
extends CSwingSpinner {
    private static final ILogger LOG = CLoggerFactory.getLogger(CSwingSlider.class);

    public CSwingListSpinner(@NotNull CWidgetSet aWidgetSet, @NotNull String aId, @NotNull CJsonObject aAttributes) {
        super(aWidgetSet, aId);
        SpinnerListModel model = new SpinnerListModel(new String[]{""});
        this.getComponent().setModel(model);
        CAttributeHandlerList list = this.getAttributeHandlerList();
        list.addHandler("valueList", this::applyValueList);
        list.addHandler("value", this::applyValue);
    }

    @Override
    public void addListeners() {
        super.addListeners();
        this.getComponent().addChangeListener(this::onChange);
    }

    private boolean applyValue(@NotNull String aKey, @Nullable Object aValue) {
        String value;
        if (aValue instanceof String && (value = CUtilString.fromObject((Object)aValue, null)) != null) {
            LOG.debug("Set Spinner value to: {}", new Object[]{value});
            this.startEdit();
            this.getListModel().setValue(value);
            this.stopEdit();
            return true;
        }
        return false;
    }

    private boolean applyValueList(@NotNull String aKey, @Nullable Object aValue) {
        List list = CUtilJsonStringList.fromJson((Object)aValue);
        LOG.debug("Set Spinner list to: {}", new Object[]{list});
        this.getListModel().setList(list);
        return true;
    }

    @Override
    @NotNull
    public String getWidgetType() {
        return EWidgetTypes.ListSpinner.name();
    }

    @Override
    protected void onChange(@NotNull ChangeEvent aEvent) {
        String value;
        if (this.isOnChange() && !this.isEditInProgress() && (value = this.getValueString()) != null) {
            LOG.debug("value is {}", new Object[]{value});
            this.addNotification("onChangeString", value);
            this.sendNotification();
        }
    }

    private SpinnerListModel getListModel() {
        return (SpinnerListModel)this.getComponent().getModel();
    }
}

