/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.client.swing.util;

import de.sillysky.nyssr.remoteskin.model.events.CEventColor;
import de.sillysky.nyssr.remoteskin.model.events.CEventFont;
import de.sillysky.nyssr.remoteskin.model.events.CEventIcon;
import de.sillysky.nyssr.remoteskin.model.events.CEventLabelAttributes;
import de.sillysky.nyssr.remoteskin.model.events.border.IBorder;
import java.awt.Color;
import java.awt.Font;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class CUtilLabelRenderer {
    private CUtilLabelRenderer() {
    }

    public static void handleTooltip(@NotNull JLabel aLabel, @NotNull CEventLabelAttributes aEntry) {
        String tooltip = aEntry.getTooltip();
        aLabel.setToolTipText(tooltip);
    }

    public static void handleIcon(@NotNull JLabel aLabel, @NotNull CEventLabelAttributes aEntry) {
        CEventIcon evIcon = aEntry.getIcon();
        if (evIcon != null) {
            ImageIcon icon = evIcon.createIcon(CUtilLabelRenderer.class);
            aLabel.setIcon(icon);
        } else {
            aLabel.setIcon(null);
        }
    }

    public static void handleBorder(@NotNull JLabel aLabel, @NotNull CEventLabelAttributes aEntry) {
        IBorder evBorder = aEntry.getBorder();
        if (evBorder != null) {
            Border border = evBorder.createBorder();
            aLabel.setBorder(border);
        } else {
            aLabel.setBorder(null);
        }
    }

    public static void handleFont(@NotNull JLabel aLabel, @NotNull CEventLabelAttributes aEntry, @NotNull Font aDefaultFont) {
        CEventFont evFont = aEntry.getFont();
        Font font = evFont != null ? evFont.createFont() : aDefaultFont;
        aLabel.setFont(font);
    }

    public static void handleForeground(@NotNull JLabel aLabel, @NotNull CEventLabelAttributes aEntry, @NotNull Color aDropLocationColor, @NotNull Color aSelectionColor, @NotNull Color aDefaultColor, boolean aIsSelected, boolean aIsDropLocation) {
        CEventColor evForeground;
        Color foreground = aIsDropLocation ? aDropLocationColor : (aIsSelected ? aSelectionColor : ((evForeground = aEntry.getForeground()) != null ? evForeground.createColor() : aDefaultColor));
        aLabel.setForeground(foreground);
    }

    public static void handleBackground(@NotNull JLabel aLabel, @NotNull CEventLabelAttributes aEntry, @NotNull Color aDropLocationColor, @NotNull Color aSelectionColor, @NotNull Color aDefaultColor, boolean aIsSelected, boolean aIsDropLocation, boolean aOpaque) {
        Color background = null;
        if (aIsDropLocation) {
            aLabel.setOpaque(true);
            background = aDropLocationColor;
        } else if (aIsSelected) {
            aLabel.setOpaque(true);
            background = aSelectionColor;
        } else {
            aLabel.setOpaque(aOpaque);
            if (aOpaque) {
                CEventColor evBackground = aEntry.getBackground();
                background = evBackground != null ? evBackground.createColor() : aDefaultColor;
            }
        }
        if (background != null) {
            aLabel.setBackground(background);
        }
    }
}

