/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.dialog.preset.newpreset;

import de.sillysky.nyssr.app.CApplicationDescription;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.widget.CWidgetId;
import de.sillysky.nyssr.id.widget.CWidgetSetId;
import de.sillysky.nyssr.impl.dialog.preset.newpreset.CNewPresetModel;
import de.sillysky.nyssr.impl.dialog.preset.newpreset.CNewPresetTarget;
import de.sillysky.nyssr.remoteskin.model.events.CEventButtonPressedNotification;
import de.sillysky.nyssr.remoteskin.model.events.CEventComboBoxContent;
import de.sillysky.nyssr.remoteskin.model.events.CEventComboBoxSelectionNotification;
import de.sillysky.nyssr.remoteskin.model.events.CEventLabelItem;
import de.sillysky.nyssr.remoteskin.model.events.CEventTextChangeNotification;
import de.sillysky.nyssr.remoteskin.model.events.CEventWindowNotification;
import de.sillysky.nyssr.remoteskin.server.context.IRemoteSkinServerContext;
import de.sillysky.nyssr.remoteskin.server.context.IWidgetApi;
import de.sillysky.nyssr.remoteskin.server.listeners.IButtonPressedListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IComboBoxSelectionListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IListener;
import de.sillysky.nyssr.remoteskin.server.listeners.ITextChangeListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IWindowClosingListener;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.CUtilUuid;
import java.util.TreeSet;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

class CNewPresetUi {
    private final CNewPresetModel mModel;
    private final IRemoteSkinServerContext mServerContext;
    private final IWidgetApi mApi;
    private final CWidgetSetId mWs601;
    private final CWidgetId mDialog;
    private final CWidgetId m601TfPresetName;
    private final CWidgetId m601ComboBoxAppId;
    private final CWidgetId m601TfAppName;
    private final CWidgetId m601TfShortDesc;
    private final CWidgetId m601TfLongDesc;
    private final CWidgetId m601ButtonOkay;
    private final CWidgetId m601ButtonCancel;
    private final CWidgetId m601LabelMessage;

    CNewPresetUi(@NotNull CNewPresetModel aModel) {
        this.mModel = aModel;
        this.mServerContext = this.mModel.getServerContext();
        this.mApi = this.mServerContext.getWidgetApi();
        String instance = aModel.getParent().getWidgetSetId().getInstance();
        this.mWs601 = CWidgetSetId.create((String)"@601_NewPreset", (String)instance);
        this.mDialog = CWidgetId.create((String)"#601_Dialog", (CWidgetSetId)this.mWs601);
        this.mApi.addListener(this.mDialog, (IListener)((IWindowClosingListener)this::onDialogClosing));
        this.m601TfPresetName = CWidgetId.create((String)"#601_TextField_PresetName", (CWidgetSetId)this.mWs601);
        this.mApi.addListener(this.m601TfPresetName, (IListener)((ITextChangeListener)this::onTextChangeTfPresetName));
        this.m601ComboBoxAppId = CWidgetId.create((String)"#601_ComboBox_AppID", (CWidgetSetId)this.mWs601);
        this.mApi.addListener(this.m601ComboBoxAppId, (IListener)((IComboBoxSelectionListener)this::onComboBoxSelection));
        this.m601TfAppName = CWidgetId.create((String)"#601_TextField_AppName", (CWidgetSetId)this.mWs601);
        this.m601TfShortDesc = CWidgetId.create((String)"#601_TextField_ShortDesc", (CWidgetSetId)this.mWs601);
        this.m601TfLongDesc = CWidgetId.create((String)"#601_TextField_LongDesc", (CWidgetSetId)this.mWs601);
        this.m601ButtonOkay = CWidgetId.create((String)"#601_Button_Okay", (CWidgetSetId)this.mWs601);
        this.mApi.addListener(this.m601ButtonOkay, (IListener)((IButtonPressedListener)this::onButtonOkayPressed));
        this.m601ButtonCancel = CWidgetId.create((String)"#601_Button_Cancel", (CWidgetSetId)this.mWs601);
        this.mApi.addListener(this.m601ButtonCancel, (IListener)((IButtonPressedListener)this::onButtonCancelPressed));
        this.m601LabelMessage = CWidgetId.create((String)"#601_Label_Message", (CWidgetSetId)this.mWs601);
    }

    private void widgetSet601Mounted(@NotNull CWidgetSetId aWidgetSetId) throws CException {
        this.mModel.getTarget().sendGetApplications();
        this.mApi.pack(this.mDialog);
        this.mApi.centerWidget(this.mDialog, this.mModel.getParent());
        this.mApi.setVisible(this.mDialog, true);
        this.mServerContext.sendUpdate();
    }

    private void onButtonCancelPressed(@NotNull CEventButtonPressedNotification aValues) throws CException {
        this.unmount(false);
    }

    private void onButtonOkayPressed(@NotNull CEventButtonPressedNotification aValues) throws CException {
        CNewPresetTarget target = this.mModel.getTarget();
        target.showMessage("Create Preset...");
        target.sendNewPreset();
    }

    private void onDialogClosing(@NotNull CEventWindowNotification aWindowEvent) throws CException {
        this.unmount(false);
    }

    private void onTextChangeTfPresetName(@NotNull CEventTextChangeNotification aValues) {
        String text = aValues.getText();
        this.mModel.setNewPresetName(text);
        boolean valid = false;
        if (CUtilString.isValid((String)text)) {
            if (this.mModel.existPreset(text)) {
                this.mModel.getTarget().showMessage("Preset already exists");
            } else {
                this.mModel.getTarget().showMessage("");
                valid = true;
            }
        }
        if (valid != this.mModel.isButtonOkayEnabled()) {
            this.mModel.setButtonOkayEnabled(valid);
            this.mApi.setEnabled(this.m601ButtonOkay, valid);
            this.mServerContext.sendUpdate();
        }
    }

    private void onComboBoxSelection(@NotNull CEventComboBoxSelectionNotification aSelection) {
        String entryId = aSelection.getEntryId();
        UUID appId = CUtilUuid.fromString((String)entryId);
        CApplicationDescription app = this.mModel.getApplicationById(appId);
        if (app != null) {
            this.mModel.setAppIdChosen(appId);
            this.mApi.setText(this.m601TfAppName, app.getName());
            this.mApi.setText(this.m601TfShortDesc, app.getShortDescription());
            this.mApi.setText(this.m601TfLongDesc, app.getLongDescription());
            this.mServerContext.sendUpdate();
        }
    }

    boolean showMessage(@NotNull String aMessage, boolean aUpdate) {
        String message = this.mModel.getMessage();
        if (!message.equals(aMessage)) {
            this.mModel.setMessage(aMessage);
            this.mApi.setText(this.m601LabelMessage, aMessage);
            this.sendUpdate(aUpdate);
            return true;
        }
        return false;
    }

    void sendApplications(boolean aUpdate) {
        TreeSet<CApplicationDescription> t = new TreeSet<CApplicationDescription>(this.mModel.getApplications());
        CEventComboBoxContent event = new CEventComboBoxContent();
        for (CApplicationDescription ad : t) {
            CEventLabelItem item = new CEventLabelItem(ad.getAppId().toString());
            item.getAttributes().setValue((Object)ad.getName());
            event.add(item);
        }
        this.mApi.setComboData(this.m601ComboBoxAppId, event);
        this.mApi.selectItem(this.m601ComboBoxAppId, t.first().getAppId().toString());
        this.sendUpdate(aUpdate);
    }

    public void sendUpdate(boolean aUpdate) {
        if (aUpdate) {
            this.mServerContext.sendUpdate();
        }
    }

    void unmount(boolean aResult) throws CException {
        this.mApi.unmount(this.mDialog);
        this.mServerContext.sendUpdate();
        this.mModel.getTarget().finish(aResult);
    }

    void mountWidgetSet601() {
        this.mServerContext.mountWidgetSet(this.mWs601, this.mModel.getParent(), null, this::widgetSet601Mounted);
        this.mServerContext.sendUpdate();
    }
}

