/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.dialog.preset.newpreset;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.app.CApplicationDescription;
import de.sillysky.nyssr.app.records.CRecordAppAddPreset;
import de.sillysky.nyssr.app.records.CRecordAppGetSupportedApplications;
import de.sillysky.nyssr.app.records.CRecordDataApplicationPreset;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.widget.CWidgetId;
import de.sillysky.nyssr.impl.dialog.preset.CPresetModel;
import de.sillysky.nyssr.impl.dialog.preset.newpreset.CNewPresetModel;
import de.sillysky.nyssr.impl.dialog.preset.newpreset.CNewPresetUi;
import de.sillysky.nyssr.impl.dialog.preset.records.CRecordDlgNewPresetClosed;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import java.util.Collection;
import java.util.UUID;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CNewPresetTarget
extends CTarget {
    private static final ILogger LOG = CLoggerFactory.getLogger(CNewPresetTarget.class);
    @NonNls
    private static final IId TIMER_ID = CIdFactory.fromObject((Object)"TimerMessage");
    private final CNewPresetModel mModel;
    private final CNewPresetUi mUi;
    private long mTimerHandle = 0L;

    public CNewPresetTarget(@NotNull CPresetModel aParentModel, @NotNull CTargetAddress aOwner, @NotNull CWidgetId aParent, @NotNull Collection<String> aExistingPresetNames) {
        this.mModel = new CNewPresetModel(this, aParentModel, aOwner, aParent, aExistingPresetNames);
        this.mUi = new CNewPresetUi(this.mModel);
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordAppGetSupportedApplications.ID, this::asyncAnswerGetSupportedApplications);
        this.addMessageHandler(CRecordAppAddPreset.ID, this::asyncAnswerRegisterApplicationPreset);
        this.addMessageHandler(TIMER_ID, this::asyncTimer);
    }

    private boolean asyncAnswerGetSupportedApplications(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            CRecord[] recArray = CRecordAppGetSupportedApplications.getApplications((CRecord)aRecord, null);
            if (recArray != null) {
                this.mModel.clearApplications();
                for (CRecord rec : recArray) {
                    CApplicationDescription app = new CApplicationDescription(rec);
                    this.mModel.addApplication(app);
                }
                this.mUi.sendApplications(true);
            }
            return true;
        }
        return false;
    }

    private boolean asyncAnswerRegisterApplicationPreset(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            CRecord rec = CRecordAppAddPreset.getApplicationPreset((CRecord)aRecord, null);
            String presetName = CRecordDataApplicationPreset.getPresetName((CRecord)rec, (String)"");
            int resultCode = aEnvelope.getResultCode();
            if (resultCode == 0) {
                this.mModel.getParentModel().getPresetTarget().addMessage(false, "Preset %s created.", presetName);
                this.mUi.unmount(true);
            } else {
                this.mModel.getParentModel().getPresetTarget().addMessage(true, "Couldn't create Preset %s: %d - %s", presetName, resultCode, aEnvelope.getResultText());
            }
            return true;
        }
        return false;
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        this.mUi.mountWidgetSet601();
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncTimer(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        this.mTimerHandle = 0L;
        this.mUi.showMessage("", true);
        aEnvelope.setResultSuccess();
        return true;
    }

    void finish(boolean aOkay) throws CException {
        CEnvelope env = CEnvelope.forSingleTarget((CTargetAddress)this.mModel.getDialogOwner());
        CRecord record = CRecordDlgNewPresetClosed.create();
        CRecordDlgNewPresetClosed.setOkay(record, aOkay);
        if (aOkay) {
            CRecordDlgNewPresetClosed.setPresetName(record, this.mModel.getNewPresetName());
            CRecordDlgNewPresetClosed.setApplicationId(record, this.mModel.getAppIdChosen());
        }
        this.sendNotification(env, record);
        if (this.mTimerHandle != 0L) {
            this.mModel.getDependencies().getTimerManager().dismissTimer(this.mTimerHandle);
            this.mTimerHandle = 0L;
        }
        this.deregisterTarget();
    }

    void sendGetApplications() throws CException {
        CEnvelope env = CEnvelope.forRemoteNanoService(CRecordAppGetSupportedApplications.class, (CNodeAddress)this.mModel.getNodeAddressOfAppStore());
        CRecord record = CRecordAppGetSupportedApplications.create();
        this.sendRequest(env, record);
    }

    void sendNewPreset() throws CException {
        CEnvelope env = CEnvelope.forRemoteNanoService(CRecordAppAddPreset.class, (CNodeAddress)this.mModel.getNodeAddressOfAppStore());
        CRecord rec = CRecordDataApplicationPreset.create();
        CRecordDataApplicationPreset.setApplicationId((CRecord)rec, (UUID)this.mModel.getAppIdChosen());
        CRecordDataApplicationPreset.setPresetName((CRecord)rec, (String)this.mModel.getNewPresetName());
        CRecord record = CRecordAppAddPreset.create();
        CRecordAppAddPreset.setApplicationPreset((CRecord)record, (CRecord)rec);
        this.sendRequest(env, record);
    }

    void showMessage(String aMessage) {
        boolean updated = this.mUi.showMessage(aMessage, true);
        if (updated && !aMessage.isEmpty()) {
            if (this.mTimerHandle == 0L) {
                this.mTimerHandle = this.mModel.getDependencies().getTimerManager().createAndStartTimer(TIMER_ID, this.getAddress(), 3000L, false, null);
            } else {
                this.mModel.getDependencies().getTimerManager().resetTimer(this.mTimerHandle);
            }
        }
    }
}

