/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.dialog.preset.editproperty;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.widget.CWidgetId;
import de.sillysky.nyssr.impl.dialog.preset.CPresetModel;
import de.sillysky.nyssr.impl.dialog.preset.editproperty.CEditPropertyModel;
import de.sillysky.nyssr.impl.dialog.preset.editproperty.CEditPropertyUi;
import de.sillysky.nyssr.impl.dialog.preset.records.CRecordDlgEditPropertyClosed;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import de.sillysky.nyssr.util.properties.CStringProperty;
import org.jetbrains.annotations.NotNull;

public class CEditPropertyTarget
extends CTarget {
    private final CEditPropertyModel mModel;
    private final CEditPropertyUi mUi;

    public CEditPropertyTarget(@NotNull CPresetModel aParentModel, @NotNull CTargetAddress aOwner, @NotNull CWidgetId aParent, @NotNull String aKey, @NotNull String aValue, boolean aCreate) {
        this.mModel = new CEditPropertyModel(aParentModel, this, aOwner, aParent, aKey, aValue, aCreate);
        this.mUi = new CEditPropertyUi(this.mModel);
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        this.mUi.mountWidgetSet();
        aEnvelope.setResultSuccess();
        return true;
    }

    void finish(boolean aOkay) throws CException {
        CEnvelope env = CEnvelope.forSingleTarget((CTargetAddress)this.mModel.getOwner());
        CRecord record = CRecordDlgEditPropertyClosed.create();
        CRecordDlgEditPropertyClosed.setOkay(record, aOkay);
        CRecordDlgEditPropertyClosed.setCreate(record, this.mModel.isCreate());
        if (aOkay) {
            CRecordDlgEditPropertyClosed.setProperty(record, new CStringProperty(this.mModel.getKey(), this.mModel.getValue()));
        }
        this.sendNotification(env, record);
        this.deregisterTarget();
    }
}

