/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.app.records;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISlot;
import de.sillysky.nyssr.util.properties.CStringProperties;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public final class CRecordDataApplication
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject((Object)"223a161a-3158-4860-9da4-0257d80189a4");
    public static final String NAME = "DataApplication";
    public static final String DESCRIPTION = "An application record. Data. Describes an application.";
    public static final String SLOT_DEFAULT_PROPERTIES = "6";
    public static final String SLOT_ICON = "5";
    public static final String SLOT_ID = "1";
    public static final String SLOT_LONG_DESCRIPTION = "4";
    public static final String SLOT_NAME = "2";
    public static final String SLOT_SHORT_DESCRIPTION = "3";
    public static final String[] NAMESPACES = new String[0];
    public static final boolean IS_NANO_SERVICE = false;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static CStringProperties getDefaultProperties(@NotNull CRecord aRecord, CStringProperties aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_DEFAULT_PROPERTIES);
        if (slot == null) {
            return aDefault;
        }
        return (CStringProperties)slot.getValue();
    }

    public static String getIcon(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_ICON);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static UUID getId(@NotNull CRecord aRecord, UUID aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_ID);
        if (slot == null) {
            return aDefault;
        }
        return (UUID)slot.getValue();
    }

    public static String getLongDescription(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_LONG_DESCRIPTION);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static String getName(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_NAME);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static String getShortDescription(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_SHORT_DESCRIPTION);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static void setDefaultProperties(@NotNull CRecord aRecord, CStringProperties aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.STRING_PROPERTIES, (Object)aValue);
        aRecord.addSlot(SLOT_DEFAULT_PROPERTIES, slot);
    }

    public static void setIcon(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.STRING, (Object)aValue);
        aRecord.addSlot(SLOT_ICON, slot);
    }

    public static void setId(@NotNull CRecord aRecord, UUID aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.UUID, (Object)aValue);
        aRecord.addSlot(SLOT_ID, slot);
    }

    public static void setLongDescription(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.STRING, (Object)aValue);
        aRecord.addSlot(SLOT_LONG_DESCRIPTION, slot);
    }

    public static void setName(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.STRING, (Object)aValue);
        aRecord.addSlot(SLOT_NAME, slot);
    }

    public static void setShortDescription(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.STRING, (Object)aValue);
        aRecord.addSlot(SLOT_SHORT_DESCRIPTION, slot);
    }
}

