/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.app.records;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISlot;
import org.jetbrains.annotations.NotNull;

public final class CRecordAppDeletePresetProperty
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject((Object)"0524530c-fb19-426d-b0c6-1f7c523b564c");
    public static final String NAME = "AppDeletePresetProperty";
    public static final String DESCRIPTION = "Delete an Application Preset Property.";
    public static final String SLOT_PRESET_NAME = "1";
    public static final String SLOT_PROPERTY_KEY = "2";
    public static final String[] NAMESPACES = new String[]{"SYSTEM"};
    public static final boolean IS_NANO_SERVICE = true;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static String getPresetName(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_PRESET_NAME);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static String getPropertyKey(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_PROPERTY_KEY);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static void setPresetName(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.STRING, (Object)aValue);
        aRecord.addSlot(SLOT_PRESET_NAME, slot);
    }

    public static void setPropertyKey(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.STRING, (Object)aValue);
        aRecord.addSlot(SLOT_PROPERTY_KEY, slot);
    }
}

