/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.web.dialog.login;

import de.sillysky.nyssr.address.CNodeId;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.impl.web.dialog.login.C00100Login;
import de.sillysky.nyssr.impl.web.dialog.login.IDependencies;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.namespace.INamespaceFactory;
import de.sillysky.nyssr.nanoservice.CDescriptionOfRecord;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import de.sillysky.nyssr.web.dialog.login.CConstants;
import de.sillysky.nyssr.web.dialog.login.records.CRecordShowWebLoginDialog;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

class C00100LoginFactory
extends CTarget
implements IService {
    private final IDependencies mDependencies;

    C00100LoginFactory(@NotNull IDependencies aDependencies) {
        this.mDependencies = aDependencies;
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordShowWebLoginDialog.ID, this::asyncShowLoginDialog);
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        INamespaceFactory nf = this.mDependencies.getNamespaceFactory();
        IId nid = CIdFactory.fromObject((Object)"WebLogin");
        INamespace ns = nf.createAndRegisterNamespace(nid, "WebLogin Namespace");
        ns.getTargetRegistry().registerTarget((ITarget)this);
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        this.mDependencies.getHelperForLocalMicroServices().deregisterMicroServices(this.getAddress());
        this.deregisterTarget();
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.registerMicroService();
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncShowLoginDialog(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CTargetAddress clientTargetAddress = CRecordShowWebLoginDialog.getClientTargetAddress((CRecord)aRecord, null);
        CUtilCheck.checkNotNull((Object)clientTargetAddress, (String)"clientTargetAddress missing", (Object[])new Object[0]);
        CTargetAddress ownerTargetAddress = CRecordShowWebLoginDialog.getOwnerTargetAddress((CRecord)aRecord, null);
        CUtilCheck.checkNotNull((Object)ownerTargetAddress, (String)"ownerTargetAddress missing", (Object[])new Object[0]);
        String parentWidgetId = CRecordShowWebLoginDialog.getParentWidgetId((CRecord)aRecord, null);
        CUtilCheck.checkNotNull((Object)parentWidgetId, (String)"parentWidgetId missing", (Object[])new Object[0]);
        String userId = CRecordShowWebLoginDialog.getUserId((CRecord)aRecord, (String)"");
        C00100Login tgt = new C00100Login(clientTargetAddress, ownerTargetAddress, parentWidgetId, userId);
        this.getTargetRegistry().registerTarget((ITarget)tgt);
        CRecordShowWebLoginDialog.setDialogTargetAddress((CRecord)aRecord, (CTargetAddress)tgt.getAddress());
        aEnvelope.setResultSuccess();
        return true;
    }

    private void registerMicroService() throws CException {
        ArrayList<CDescriptionOfRecord> nanos = new ArrayList<CDescriptionOfRecord>();
        nanos.add(new CDescriptionOfRecord(CRecordShowWebLoginDialog.ID, "Create and show a login dialog"));
        this.mDependencies.getHelperForLocalMicroServices().registerMicroService(CConstants.MICRO_SERVICE_ID, "Web Login Dialog Factory", nanos, CNodeId.getLocal().getId(), this.getAddress());
    }
}

