/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.file.store.database;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.file.store.common.CUtilFileStore;
import de.sillysky.nyssr.impl.file.store.records.CRecordFileStoreAddFileToList;
import de.sillysky.nyssr.job.CAbstractJob;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import de.sillysky.nyssr.thread.EThreadPriority;
import de.sillysky.nyssr.util.files.CUtilFile;
import de.sillysky.nyssr.util.hash.CMd5;
import de.sillysky.nyssr.util.hash.CUtilMd5;
import java.io.File;
import java.nio.file.attribute.FileTime;
import org.jetbrains.annotations.NotNull;

class CJobHashFile
extends CAbstractJob {
    private final File mFile;
    private final CTargetAddress mParent;

    CJobHashFile(@NotNull File aFile, @NotNull CTargetAddress aParent) {
        this.mFile = aFile;
        this.mParent = aParent;
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
    }

    @NotNull
    public EThreadPriority getPriority() {
        return EThreadPriority.LOW;
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CMd5 md5 = CUtilMd5.calculate((File)this.mFile, null);
        if (md5 != null) {
            String hash = md5.toBase32();
            @NotNull FileTime[] fileTimes = CUtilFile.getFileTimes((File)this.mFile);
            CEnvelope env = CEnvelope.forSingleTarget((CTargetAddress)this.mParent);
            CRecord file = CUtilFileStore.fileToRecord(hash, this.mFile.getPath(), this.mFile.length(), fileTimes[0].toInstant(), fileTimes[1].toInstant());
            CRecord record = CRecordFileStoreAddFileToList.create();
            CRecordFileStoreAddFileToList.setFile(record, file);
            this.sendNotification(env, record);
        }
        super.notifyJobStopped();
        aEnvelope.setResultSuccess();
        return true;
    }

    @NotNull
    public String getJobName() {
        return "Hash-" + this.mFile.getPath();
    }
}

