/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.web.dialog.addright;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.web.dialog.addright.CConstants;
import de.sillysky.nyssr.json.CUtilJson;
import de.sillysky.nyssr.login.records.CRecordSessionCreateRight;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.remoteskin.web.dialog.records.CRecordWebDismissDialog;
import de.sillysky.nyssr.remoteskin.web.protocol.CWebApi;
import de.sillysky.nyssr.remoteskin.web.protocol.CWebDialogApi;
import de.sillysky.nyssr.remoteskin.web.protocol.records.CRecordWebNotifyClick1;
import de.sillysky.nyssr.remoteskin.web.protocol.records.CRecordWebNotifyClick2;
import de.sillysky.nyssr.session.CConstantsSession;
import de.sillysky.nyssr.session.api.CRight;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.properties.CStringProperties;
import org.jetbrains.annotations.NotNull;

class C00305AddRight
extends CTarget {
    private final String mSessionToken;
    private final CTargetAddress mClientTargetAddress;
    private final CTargetAddress mOwnerTargetAddress;
    private CWebApi mWebApi;
    private CWebDialogApi mWebDialogApi;
    private static final String ID_INDEX_MODAL = "rs_30cb3f8d-cefd-40c5-81b8-7791895c7b95";
    private static final String ID_00305_MODAL = "id_00305_modal";
    private static final String ID_00305_CANCEL = "id_00305_cancel";
    private static final String ID_00305_SAVE = "id_00305_save";
    private static final String ID_00305_RIGHT_ID = "id_00305_right_id";
    private static final String ID_00305_DESCRIPTION = "id_00305_description";
    private static final String ID_00305_RIGHT_ID_ALERT = "id_00305_right_id_alert";
    private static final String[] WIDGETS = new String[]{"id_00305_cancel", "id_00305_save"};
    private final CRight mRight = new CRight();

    public C00305AddRight(@NotNull String aSessionToken, @NotNull CTargetAddress aClientTargetAddress, @NotNull CTargetAddress aOwnerTargetAddress) {
        this.mSessionToken = aSessionToken;
        this.mClientTargetAddress = aClientTargetAddress;
        this.mOwnerTargetAddress = aOwnerTargetAddress;
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordWebDismissDialog.ID, this::asyncWebDismissDialog);
        this.addMessageHandler(CRecordWebNotifyClick1.ID, this::asyncWebNotifyClick1);
        this.addMessageHandler(CRecordWebNotifyClick2.ID, this::asyncWebNotifyClick2);
        this.addMessageHandler(CRecordSessionCreateRight.ID, this::asyncSessionCreateRight);
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.mWebApi = new CWebApi((ITarget)this, this.mClientTargetAddress);
        this.mWebDialogApi = new CWebDialogApi((ITarget)this, this.mClientTargetAddress);
        this.mWebApi.registerWidgets(WIDGETS);
        this.showDialog();
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncWebDismissDialog(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.finish(3);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncWebNotifyClick1(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        boolean errors = false;
        CStringProperties values = CRecordWebNotifyClick1.getValues((CRecord)aRecord, null);
        if (values != null) {
            String alert;
            String rightId = values.get(ID_00305_RIGHT_ID, "");
            if (CUtilString.isEmpty((String)rightId)) {
                alert = CUtilJson.loadJson(((Object)((Object)this)).getClass(), (String)"/html/00305_alert.html");
                alert = CUtilString.replaceFirstOccurrence((String)alert, (String)"{message}", (String)"ID is empty.");
                this.mWebApi.setInnerHtml(ID_00305_RIGHT_ID_ALERT, alert);
                errors = true;
            } else if (rightId.contains(" ")) {
                alert = CUtilJson.loadJson(((Object)((Object)this)).getClass(), (String)"/html/00305_alert.html");
                alert = CUtilString.replaceFirstOccurrence((String)alert, (String)"{message}", (String)"ID contains spaces.");
                this.mWebApi.setInnerHtml(ID_00305_RIGHT_ID_ALERT, alert);
                errors = true;
            } else {
                this.mRight.setId(rightId);
            }
            String description = values.get(ID_00305_DESCRIPTION, "");
            this.mRight.setDescription(description);
            if (!errors) {
                this.sendAddRight(this.mRight);
            }
        } else {
            this.finish(1);
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncWebNotifyClick2(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.finish(2);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncSessionCreateRight(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            int resultCode = aEnvelope.getResultCode();
            if (resultCode == 0) {
                this.finish(0);
            } else {
                String alert = CUtilJson.loadJson(((Object)((Object)this)).getClass(), (String)"/html/00305_alert.html");
                alert = CUtilString.replaceFirstOccurrence((String)alert, (String)"{message}", (String)aEnvelope.getResultText());
                this.mWebApi.setInnerHtml(ID_00305_RIGHT_ID_ALERT, alert);
            }
            return true;
        }
        return false;
    }

    private void showDialog() throws CException {
        String main = CUtilJson.loadJson(((Object)((Object)this)).getClass(), (String)"/html/00305_add_right.html");
        this.mWebApi.removeElement(ID_00305_MODAL);
        this.mWebApi.setInnerHtml(ID_INDEX_MODAL, main);
        this.mWebApi.showModal(ID_00305_MODAL);
        this.mWebApi.addClickListener1(ID_00305_SAVE, new String[]{ID_00305_RIGHT_ID, ID_00305_DESCRIPTION});
        this.mWebApi.addClickListener2(new String[]{ID_00305_CANCEL});
    }

    void sendAddRight(@NotNull CRight aRight) throws CException {
        CEnvelope env = CEnvelope.forMicroService((IId)CConstantsSession.MICRO_SERVICE_ID);
        CRecord record = CRecordSessionCreateRight.create();
        CRecordSessionCreateRight.setRight((CRecord)record, (String)aRight.getId());
        CRecordSessionCreateRight.setDescription((CRecord)record, (String)aRight.getDescription());
        CRecordSessionCreateRight.setProtected((CRecord)record, (boolean)false);
        this.sendRequest(env, record);
    }

    private void finish(int aReason) throws CException {
        this.mWebApi.removeElement(ID_00305_MODAL);
        this.mWebDialogApi.notifyDismissed(this.mOwnerTargetAddress, CConstants.MICRO_SERVICE_ID, aReason, new String[]{this.mRight.getId()});
        this.mWebApi.deregisterWidgetOwner();
        this.deregisterTarget();
    }
}

