/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.network.link;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.network.router.records.CRecordNetworkLinkData;
import de.sillysky.nyssr.record.CRecord;
import java.time.ZonedDateTime;
import org.jetbrains.annotations.NotNull;

public class CLinkDto {
    private final CNodeAddress mNode1;
    private final CNodeAddress mNode2;
    private final int mCosts;
    private final ZonedDateTime mTimeOfMeasurement;
    private final ZonedDateTime mTimeOfCreation;

    public static CLinkDto fromRecord(@NotNull CRecord aRecord) throws CException {
        if (!CRecordNetworkLinkData.ID.equals((Object)aRecord.getId())) {
            throw new CException(31).append("Wrong record");
        }
        CNodeAddress node1 = CRecordNetworkLinkData.getNode1(aRecord, null);
        CNodeAddress node2 = CRecordNetworkLinkData.getNode2(aRecord, null);
        int costs = CRecordNetworkLinkData.getCosts(aRecord, 0);
        ZonedDateTime costMeasureTime = CRecordNetworkLinkData.getCostMeasureTime(aRecord, ZonedDateTime.now());
        return new CLinkDto(node1, node2, costs, costMeasureTime, ZonedDateTime.now());
    }

    public CLinkDto(@NotNull CNodeAddress aNode1, @NotNull CNodeAddress aNode2, int aCosts, @NotNull ZonedDateTime aTimeOfMeasurement, @NotNull ZonedDateTime aTimeOfCreation) {
        if (aNode1.toString().compareTo(aNode2.toString()) < 0) {
            this.mNode1 = aNode1;
            this.mNode2 = aNode2;
        } else {
            this.mNode1 = aNode2;
            this.mNode2 = aNode1;
        }
        this.mCosts = aCosts;
        this.mTimeOfMeasurement = aTimeOfMeasurement;
        this.mTimeOfCreation = aTimeOfCreation;
    }

    @NotNull
    public CNodeAddress getNode1() {
        return this.mNode1;
    }

    @NotNull
    public CNodeAddress getNode2() {
        return this.mNode2;
    }

    public int getCosts() {
        return this.mCosts;
    }

    @NotNull
    public ZonedDateTime getTimeOfMeasurement() {
        return this.mTimeOfMeasurement;
    }

    @NotNull
    public ZonedDateTime getTimeOfCreation() {
        return this.mTimeOfCreation;
    }

    public boolean equals(Object aObject) {
        if (this == aObject) {
            return true;
        }
        if (aObject == null || this.getClass() != aObject.getClass()) {
            return false;
        }
        CLinkDto cLinkDto = (CLinkDto)aObject;
        if (!this.mNode1.equals((Object)cLinkDto.mNode1)) {
            return false;
        }
        return this.mNode2.equals((Object)cLinkDto.mNode2);
    }

    public int hashCode() {
        int result = this.mNode1.hashCode();
        result = 31 * result + this.mNode2.hashCode();
        return result;
    }
}

