/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.dialog.property.editor;

import de.sillysky.nyssr.address.CNodeId;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.dialog.property.editor.CConstantsDialogPropertyEditor;
import de.sillysky.nyssr.dialog.property.editor.records.CRecordOpenDialogPropertyEditor;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.common.CWellKnownNID;
import de.sillysky.nyssr.impl.dialog.property.editor.CMainTarget;
import de.sillysky.nyssr.impl.dialog.property.editor.IDependencies;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.namespace.INamespaceFactory;
import de.sillysky.nyssr.nanoservice.CDescriptionOfRecord;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.remoteskin.server.dialog.CDialogDto;
import de.sillysky.nyssr.remoteskin.server.dialog.CUtilDialogHelper;
import de.sillysky.nyssr.remoteskin.server.dialog.records.CRecordCloseDialog;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

class CDialogFactory
extends CTarget
implements IService {
    private static final ILogger LOG = CLoggerFactory.getLogger(CDialogFactory.class);
    private final IDependencies mDependencies;

    CDialogFactory(@NotNull IDependencies aDependencies) {
        this.mDependencies = aDependencies;
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordOpenDialogPropertyEditor.ID, this::asyncOpenDialogPropertyEditor);
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        LOG.debug("Module {} has been started.", new Object[]{"Dialog Property Editor"});
        INamespaceFactory namespaceFactory = this.mDependencies.getNamespaceFactory();
        INamespace ns = namespaceFactory.createAndRegisterNamespace(CWellKnownNID.REMOTE_SKIN, "Remote UI");
        ns.getTargetRegistry().registerTarget((ITarget)this);
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        this.mDependencies.getHelperForLocalMicroServices().deregisterMicroServices(this.getAddress());
        this.deregisterTarget();
        LOG.debug("Module {} has been removed.", new Object[]{"Dialog Property Editor"});
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.registerMicroService();
        return true;
    }

    private boolean asyncOpenDialogPropertyEditor(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CDialogDto dto = CUtilDialogHelper.convertRecordToDto((CEnvelope)aEnvelope, (CRecord)aRecord, (CTargetAddress)this.getAddress());
        LOG.debug("Start Dialog User instance for {}.", new Object[]{aEnvelope.getSender()});
        CMainTarget tgt = new CMainTarget(this.mDependencies, dto, aRecord);
        this.getTargetRegistry().registerTarget((ITarget)tgt);
        CRecordOpenDialogPropertyEditor.setTargetAddress((CRecord)aRecord, (CTargetAddress)tgt.getAddress());
        aEnvelope.setResultSuccess();
        return true;
    }

    private void registerMicroService() throws CException {
        ArrayList<CDescriptionOfRecord> nanos = new ArrayList<CDescriptionOfRecord>();
        nanos.add(new CDescriptionOfRecord(CRecordOpenDialogPropertyEditor.ID, "Open Dialog Property Editor"));
        nanos.add(new CDescriptionOfRecord(CRecordCloseDialog.ID, "Close Dialog"));
        this.mDependencies.getHelperForLocalMicroServices().registerMicroService(CConstantsDialogPropertyEditor.MICRO_SERVICE_ID, "Dialog Property Editor", nanos, CNodeId.getLocal().getId(), this.getAddress());
    }
}

