/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.link.collector;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.address.CNodeId;
import de.sillysky.nyssr.address.CSegmentId;
import de.sillysky.nyssr.impl.link.collector.CSegmentRoutingHint;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class CSegmentRoutingHintList {
    private final Set<CSegmentRoutingHint> mHints = new HashSet<CSegmentRoutingHint>();

    CSegmentRoutingHintList() {
    }

    void add(@NotNull CSegmentRoutingHint aHint) {
        this.mHints.add(aHint);
    }

    void remove(@NotNull CSegmentId aSegmentId, @NotNull CNodeId aNodeId) {
        Iterator<CSegmentRoutingHint> it = this.mHints.iterator();
        while (it.hasNext()) {
            CSegmentRoutingHint hint = it.next();
            if (!hint.getSegment().equals((Object)aSegmentId) || !hint.getLocalNode().equals((Object)aNodeId)) continue;
            it.remove();
            return;
        }
    }

    int size() {
        return this.mHints.size();
    }

    CSegmentRoutingHint findOne(@NotNull CSegmentId aSegmentId) {
        for (CSegmentRoutingHint h : this.mHints) {
            if (!h.getSegment().equals((Object)aSegmentId)) continue;
            return h;
        }
        return null;
    }

    List<CSegmentRoutingHint> findAll(@NotNull CSegmentId aSegmentId) {
        ArrayList<CSegmentRoutingHint> list = new ArrayList<CSegmentRoutingHint>();
        for (CSegmentRoutingHint h : this.mHints) {
            if (!h.getSegment().equals((Object)aSegmentId)) continue;
            list.add(h);
        }
        return list;
    }

    public String toString() {
        return "{ " + this.size() + " Hints }";
    }

    public void removeNode(@NotNull CNodeAddress aNode) {
        this.mHints.removeIf(hint -> hint.hasNode(aNode));
    }

    public void syncNode(@NotNull CNodeAddress aNode, @NotNull CNodeAddress[] aRemoteNodes) {
        for (CNodeAddress remoteNode : aRemoteNodes) {
            CSegmentId segmentId = remoteNode.getSegmentId();
            if (segmentId.isLocal()) continue;
            this.add(new CSegmentRoutingHint(segmentId, aNode.getNodeId()));
        }
        Iterator<CSegmentRoutingHint> iterator = this.mHints.iterator();
        while (iterator.hasNext()) {
            CSegmentId segment;
            int index;
            CNodeId nodeId;
            CSegmentRoutingHint hint = iterator.next();
            CNodeId localNode = hint.getLocalNode();
            if (!localNode.equals((Object)(nodeId = aNode.getNodeId())) || (index = this.getIndexInArray(segment = hint.getSegment(), aRemoteNodes)) >= 0) continue;
            iterator.remove();
        }
    }

    private int getIndexInArray(@NotNull CSegmentId aSegment, @NotNull CNodeAddress[] aRemoteNodes) {
        int i = 0;
        for (CNodeAddress remoteNode : aRemoteNodes) {
            if (aSegment.equals((Object)remoteNode.getSegmentId())) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

