/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.app.user.manager;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.dialog.user.records.CRecordOpenDialogUser;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.widget.CWidgetId;
import de.sillysky.nyssr.id.widget.CWidgetSetId;
import de.sillysky.nyssr.impl.app.user.manager.CMessagePanelHolder;
import de.sillysky.nyssr.impl.app.user.manager.CUserDialogHolder;
import de.sillysky.nyssr.impl.app.user.manager.ILocalAppContext;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.message.panel.records.CRecordOpenDialogMessagePanel;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.remoteskin.model.events.CEventWindowNotification;
import de.sillysky.nyssr.remoteskin.server.context.IWidgetApi;
import de.sillysky.nyssr.remoteskin.server.listeners.IListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IWindowClosingListener;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import org.jetbrains.annotations.NotNull;

public class CMainTarget
extends CTarget {
    private static final ILogger LOG = CLoggerFactory.getLogger((String)"app.user.manager");
    private final ILocalAppContext mLocalAppContext;
    private final CWidgetSetId mWs800;
    private final CWidgetId m800MainFrame;
    private final CWidgetId m800MessagePanel;
    private final CWidgetId m800MainPanel;
    private final IWidgetApi mApi;
    private CUserDialogHolder mUserDialog;
    private CMessagePanelHolder mMessagePanel;

    public CMainTarget(@NotNull ILocalAppContext aLocalAppContext) {
        this.mLocalAppContext = aLocalAppContext;
        this.mApi = this.mLocalAppContext.getServerContext().getWidgetApi();
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordOpenDialogMessagePanel.ID, this::asyncOpenDialogMessagePanel);
        this.addMessageHandler(CRecordOpenDialogUser.ID, this::asyncAnswerStartDialogUser);
        this.mWs800 = CWidgetSetId.create((String)"@800_Main", (String)"1");
        this.m800MainFrame = CWidgetId.create((String)"#800_MainFrame", (CWidgetSetId)this.mWs800);
        this.mApi.addListener(this.m800MainFrame, (IListener)((IWindowClosingListener)this::onClosingWindow));
        this.m800MessagePanel = CWidgetId.create((String)"#800_Panel_Message", (CWidgetSetId)this.mWs800);
        this.m800MainPanel = CWidgetId.create((String)"#800_Panel", (CWidgetSetId)this.mWs800);
        this.mUserDialog = new CUserDialogHolder(this.mLocalAppContext, (ITarget)this);
        this.mMessagePanel = new CMessagePanelHolder(this.mLocalAppContext, (ITarget)this);
    }

    private void onClosingWindow(@NotNull CEventWindowNotification aCEventWindowNotification) {
        this.deregisterTarget();
    }

    public void notifyTargetWillBeRemoved() throws Exception {
        this.mUserDialog.deactivate();
        this.mUserDialog = null;
        this.mMessagePanel.deactivate();
        this.mMessagePanel = null;
        super.notifyTargetWillBeRemoved();
    }

    public void deactivate() {
        this.deregisterTarget();
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.mountWidgetSet800();
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncOpenDialogMessagePanel(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            if (aEnvelope.getResultCode() == 0) {
                CTargetAddress address = CRecordOpenDialogMessagePanel.getDialogTargetAddress((CRecord)aRecord, null);
                this.mMessagePanel.setAddress(address);
                this.mMessagePanel.sendAddMessageToHistory("UserManager started.");
                this.mLocalAppContext.setMessagePanel(this.mMessagePanel);
                this.mUserDialog.show(this.m800MainPanel, address);
            }
            return true;
        }
        return false;
    }

    private boolean asyncAnswerStartDialogUser(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            if (aEnvelope.getResult().isSuccess()) {
                CTargetAddress targetAddress = CRecordOpenDialogUser.getTargetAddress((CRecord)aRecord, null);
                this.mUserDialog.setAddressOfUserDialog(targetAddress);
            }
            return true;
        }
        return false;
    }

    void mountWidgetSet800() {
        this.mLocalAppContext.getServerContext().mountWidgetSet(this.mWs800, null, null, this::widgetSet800Mounted);
        this.mLocalAppContext.getServerContext().sendUpdate();
    }

    private void widgetSet800Mounted(@NotNull CWidgetSetId aWidgetSetId) throws CException {
        if (this.mWs800.equals((Object)aWidgetSetId)) {
            this.mApi.setVisible(this.m800MainFrame, true);
            this.mApi.pack(this.m800MainFrame);
            this.mLocalAppContext.getServerContext().sendUpdate();
            this.mMessagePanel.show(this.m800MessagePanel);
        }
    }
}

